"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A representation of a unitary action on the record fields
 */
class Task {
    constructor(type, sourceFields, connectorOperator, properties, destinationField) {
        this.type = type;
        this.sourceFields = sourceFields;
        this.connectorOperator = connectorOperator;
        this.properties = properties;
        this.destinationField = destinationField;
    }
    bind(_flow, source) {
        return {
            taskType: this.type,
            sourceFields: this.sourceFields,
            taskProperties: this.properties.map(({ key, value }) => ({
                key: key,
                value: value,
            })),
            connectorOperator: this.buildOperatorFor(source),
            destinationField: this.destinationField,
        };
    }
    buildOperatorFor(source) {
        const operator = {};
        const origin = this.connectorOperator.type?.asTaskConnectorOperatorOrigin ??
            source.connectorType.asTaskConnectorOperatorOrigin;
        operator[origin] = this.connectorOperator.operation;
        return operator;
    }
}
exports.Task = Task;
_a = JSII_RTTI_SYMBOL_1;
Task[_a] = { fqn: "@cdklabs/cdk-appflow.Task", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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