import { Field } from "./field";
import { IOperation, OperationBase } from "./operation";
/**
 * A representation of a mapping operation, that is an operation translating source to destination fields
 */
export interface IMapping extends IOperation {
}
/**
 * A helper interface
 */
export interface MapAllConfig {
    readonly exclude: string[];
}
/**
 * A representation of an instance of a mapping operation, that is an operation translating source to destination fields
 */
export declare class Mapping extends OperationBase implements IMapping {
    static mapAll(config?: MapAllConfig): IMapping;
    static map(from: Field, to: Field): IMapping;
    /**
     * A mapping definition building concatenation of source fields into a destination field
     * @param from an array of source fields
     * @param to a desintation field
     * @param format a format
     * @returns a mapping instance with concatenation definition
     */
    static concat(from: Field[], to: Field, format: string): Mapping;
    /**
     * Specifies an addition mapping of two numeric values from asource to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static add(sourceField1: Field, sourceField2: Field, to: Field): Mapping;
    /**
     * Specifies a multiplication mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static multiply(sourceField1: Field, sourceField2: Field, to: Field): Mapping;
    /**
     * Specifies a subtraction mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static subtract(sourceField1: Field, sourceField2: Field, to: Field): Mapping;
    /**
     * Specifies a division mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    static divide(sourceField1: Field, sourceField2: Field, to: Field): Mapping;
    /**
     * Specifies an arithmetic mapping of two numeric values from a source to a destination
     * @param sourceField1 a numeric value
     * @param sourceField2 a numeric value
     * @param to a numeric value
     * @returns an IMapping instance
     */
    private static arithmetic;
}
