"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Filter = exports.FilterCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a filter operation condtiion on a source record field
 */
class FilterCondition {
    /**
     * A condition testing whether a string-type source field contains the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringContains(field, val) {
        return FilterCondition.stringCondition(field, val, "CONTAINS");
    }
    /**
     * A condition testing whether a string-type source field equals the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringEquals(field, val) {
        return FilterCondition.stringCondition(field, val, "EQUAL_TO");
    }
    /**
     * A condition testing whether a string-type source field does not equal the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringNotEquals(field, val) {
        return FilterCondition.stringCondition(field, val, "NOT_EQUAL_TO");
    }
    static booleanEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, "EQUAL_TO");
    }
    static booleanNotEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, "NOT_EQUAL_TO");
    }
    static numberEquals(field, val) {
        return FilterCondition.numberCondition(field, val, "EQUAL_TO");
    }
    static numberNotEquals(field, val) {
        return FilterCondition.numberCondition(field, val, "NOT_EQUAL_TO");
    }
    static numberLessThan(field, val) {
        return FilterCondition.numberCondition(field, val, "LESS_THAN");
    }
    static numberLessThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, "LESS_THAN_OR_EQUAL_TO");
    }
    static numberGreaterThan(field, val) {
        return FilterCondition.numberCondition(field, val, "GREATER_THAN");
    }
    static numberGreaterThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, "GREATER_THAN_OR_EQUAL_TO");
    }
    static timestampEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, "EQUAL_TO");
    }
    static timestampNotEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, "NOT_EQUAL_TO");
    }
    static timestampLessThan(field, val) {
        return FilterCondition.timestampCondition(field, val, "LESS_THAN");
    }
    static timestampLessThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, "LESS_THAN_OR_EQUAL_TO");
    }
    static timestampGreaterThan(field, val) {
        return FilterCondition.timestampCondition(field, val, "GREATER_THAN");
    }
    static timestampGreaterThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, "GREATER_THAN_OR_EQUAL_TO");
    }
    static timestampBetween(field, lower, upper) {
        return new FilterCondition(field, "BETWEEN", [
            { key: "DATA_TYPE", value: field.dataType },
            { key: "LOWER_BOUND", value: this.valueToString(lower) },
            { key: "UPPER_BOUND", value: this.valueToString(upper) },
        ]);
    }
    static stringCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: "DATA_TYPE", value: field.dataType },
                {
                    key: "VALUES",
                    value: val.map((m) => this.valueToString(m)).join(","),
                },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: "DATA_TYPE", value: field.dataType },
            { key: "VALUE", value: this.valueToString(val) },
        ]);
    }
    static numberCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: "DATA_TYPE", value: field.dataType },
                {
                    key: "VALUES",
                    value: val.map((m) => this.valueToString(m)).join(","),
                },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: "DATA_TYPE", value: field.dataType },
            { key: "VALUE", value: this.valueToString(val) },
        ]);
    }
    static booleanCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: "DATA_TYPE", value: field.dataType },
                {
                    key: "VALUES",
                    value: val.map((m) => this.valueToString(m)).join(","),
                },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: "DATA_TYPE", value: field.dataType },
            { key: "VALUE", value: this.valueToString(val) },
        ]);
    }
    static timestampCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: "DATA_TYPE", value: field.dataType },
                {
                    key: "VALUES",
                    value: val.map((m) => this.valueToString(m)).join(","),
                },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: "DATA_TYPE", value: field.dataType },
            { key: "VALUE", value: this.valueToString(val) },
        ]);
    }
    static valueToString(value) {
        const t = typeof value;
        switch (t) {
            case "string":
                return value;
            case "number":
            case "boolean":
                return `${value}`;
            default: // meaning: Date
                return value.getTime().toString();
        }
    }
    constructor(field, filter, properties) {
        this.field = field;
        this.filter = filter;
        this.properties = properties;
        if (!field.dataType) {
            throw new Error("field dataType required");
        }
    }
}
exports.FilterCondition = FilterCondition;
_a = JSII_RTTI_SYMBOL_1;
FilterCondition[_a] = { fqn: "@cdklabs/cdk-appflow.FilterCondition", version: "0.2.1" };
/**
 * A representation of a mapping operation, that is an operation filtering records at the source
 */
class Filter extends operation_1.OperationBase {
    /**
     * Builds a filter operation on source
     * @param condition a @see FilterCondition instance
     * @returns
     */
    static when(condition) {
        return new Filter(condition);
    }
    constructor(condition) {
        super([
            new tasks_1.Task("Filter", [condition.field.name], 
            // TODO: think about source/destination here
            { operation: condition.filter }, condition.properties),
        ]);
        this.condition = condition;
    }
}
exports.Filter = Filter;
_b = JSII_RTTI_SYMBOL_1;
Filter[_b] = { fqn: "@cdklabs/cdk-appflow.Filter", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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