import { Field } from "./field";
import { IOperation, OperationBase } from "./operation";
import { TaskProperty } from "./tasks";
/**
 * A representation of a filter operation condtiion on a source record field
 */
export declare class FilterCondition {
    readonly field: Field;
    readonly filter: string;
    readonly properties: TaskProperty[];
    /**
     * A condition testing whether a string-type source field contains the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringContains(field: Field, val: string | string[]): FilterCondition;
    /**
     * A condition testing whether a string-type source field equals the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringEquals(field: Field, val: string | string[]): FilterCondition;
    /**
     * A condition testing whether a string-type source field does not equal the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringNotEquals(field: Field, val: string | string[]): FilterCondition;
    static booleanEquals(field: Field, val: boolean | boolean[]): FilterCondition;
    static booleanNotEquals(field: Field, val: boolean | boolean[]): FilterCondition;
    static numberEquals(field: Field, val: number | number[]): FilterCondition;
    static numberNotEquals(field: Field, val: number | number[]): FilterCondition;
    static numberLessThan(field: Field, val: number): FilterCondition;
    static numberLessThanEquals(field: Field, val: number): FilterCondition;
    static numberGreaterThan(field: Field, val: number): FilterCondition;
    static numberGreaterThanEquals(field: Field, val: number): FilterCondition;
    static timestampEquals(field: Field, val: Date | Date[]): FilterCondition;
    static timestampNotEquals(field: Field, val: Date | Date[]): FilterCondition;
    static timestampLessThan(field: Field, val: Date | Date[]): FilterCondition;
    static timestampLessThanEquals(field: Field, val: Date | Date[]): FilterCondition;
    static timestampGreaterThan(field: Field, val: Date | Date[]): FilterCondition;
    static timestampGreaterThanEquals(field: Field, val: Date | Date[]): FilterCondition;
    static timestampBetween(field: Field, lower: Date, upper: Date): FilterCondition;
    private static stringCondition;
    private static numberCondition;
    private static booleanCondition;
    private static timestampCondition;
    private static valueToString;
    constructor(field: Field, filter: string, properties: TaskProperty[]);
}
/**
 * A representation of a mapping operation, that is an operation filtering records at the source
 */
export interface IFilter extends IOperation {
}
/**
 * A representation of a mapping operation, that is an operation filtering records at the source
 */
export declare class Filter extends OperationBase implements IFilter {
    readonly condition: FilterCondition;
    /**
     * Builds a filter operation on source
     * @param condition a @see FilterCondition instance
     * @returns
     */
    static when(condition: FilterCondition): Filter;
    protected constructor(condition: FilterCondition);
}
