"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggeredFlowBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const flow_base_1 = require("./flow-base");
/**
 * A base class for triggered flows.
 */
class TriggeredFlowBase extends flow_base_1.FlowBase {
    /**
     *
     * @param autoActivate - a boolean value indicating whether to automatically activate the flow.
     * @param status - a {@link FlowStatus} value indicating the status to set on the flow.
     * @returns
     */
    static setStatus(autoActivate, status) {
        if (autoActivate !== undefined && status !== undefined) {
            throw new Error("Cannot specify both autoActivate and status");
        }
        return autoActivate !== undefined
            ? autoActivate
                ? flow_base_1.FlowStatus.ACTIVE
                : flow_base_1.FlowStatus.SUSPENDED
            : status !== undefined
                ? status
                : undefined;
    }
    /**
     *
     * @param scope
     * @param id
     * @param props
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.TriggeredFlowBase = TriggeredFlowBase;
_a = JSII_RTTI_SYMBOL_1;
TriggeredFlowBase[_a] = { fqn: "@cdklabs/cdk-appflow.TriggeredFlowBase", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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