"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowTimeUpdater = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
// import * as path from 'path';
const aws_cdk_lib_1 = require("aws-cdk-lib");
// import { Runtime } from 'aws-cdk-lib/aws-lambda';
// import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const api = require("./api");
const flow_time_updater_function_1 = require("./flow-time-updater-function");
class FlowTimeUpdater extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new aws_cdk_lib_1.CustomResource(this, "Resource", {
            serviceToken: FlowTimeUpdaterProvider.getOrCreate(this),
            resourceType: "Custom::FlowTimeUpdater",
            properties: {
                [api.PROP_SCHEDULE]: props.schedule.expressionString,
                [api.PROP_STARTTIME]: props.startTime && props.startTime.toISOString(),
                [api.PROP_ENDTIME]: props.endTime && props.endTime.toISOString(),
            },
        });
        this.scheduleExpression = resource.getAttString(api.ATTR_SCHEDULE);
        this.startTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_STARTTIME));
        this.endTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_ENDTIME));
    }
}
exports.FlowTimeUpdater = FlowTimeUpdater;
class FlowTimeUpdaterProvider extends constructs_1.Construct {
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = "com.amazonaws.cdk.custom-resources.flow-time-provider";
        const x = stack.node.tryFindChild(id) ||
            new FlowTimeUpdaterProvider(stack, id);
        return x.provider.serviceToken;
    }
    constructor(scope, id) {
        super(scope, id);
        this.provider = new custom_resources_1.Provider(this, "flow-time-provider", {
            onEventHandler: new flow_time_updater_function_1.FlowTimeUpdaterFunction(this, "flow-time-on-event"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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