"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
class ConnectorType {
    constructor(name, isCustom) {
        this.name = name;
        this.isCustom = isCustom;
    }
    get asProfileConnectorType() {
        return this.isCustom
            ? "CustomConnector"
            : `${this.name[0].toUpperCase()}${this.name.substring(1).toLowerCase()}`;
    }
    get asTaskConnectorOperatorOrigin() {
        return this.isCustom
            ? "customConnector"
            : `${this.name[0].toLowerCase()}${this.name.substring(1)}`;
    }
    get asProfileConnectorLabel() {
        return this.isCustom ? this.name : undefined;
    }
}
exports.ConnectorType = ConnectorType;
_a = JSII_RTTI_SYMBOL_1;
ConnectorType[_a] = { fqn: "@cdklabs/cdk-appflow.ConnectorType", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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