"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectorProfileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_appflow_1 = require("aws-cdk-lib/aws-appflow");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const connection_mode_1 = require("./connection-mode");
const appflow_permissions_manager_1 = require("../appflow-permissions-manager");
class ConnectorProfileBase extends aws_cdk_lib_1.Resource {
    /**
     * @internal
     * @experimental
     */
    static _fromConnectorProfileAttributes(scope, id, attrs) {
        if (attrs.name === undefined && attrs.arn === undefined) {
            throw new Error("Either 'name' or 'arn' needs to be defined");
        }
        const { name, arn } = attrs;
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(scope, id);
                this.credentials = undefined;
                this.arn = arn
                    ? arn
                    : aws_cdk_lib_1.Stack.of(this).formatArn({
                        service: "appflow",
                        resource: "connectorprofile",
                        resourceName: name,
                        arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
                    });
                this.name = name
                    ? name
                    : aws_cdk_lib_1.Arn.split(arn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            }
        }
        return new Import();
    }
    constructor(scope, id, props, connectorType) {
        super(scope, id, {
            physicalName: props.name ||
                aws_cdk_lib_1.Lazy.string({
                    produce: () => aws_cdk_lib_1.Names.uniqueResourceName(this, {
                        maxLength: 256,
                    }),
                }),
        });
        this.tryAddNodeDependency(this, props.key);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantKeyEncryptDecrypt(props.key);
        const resource = new aws_appflow_1.CfnConnectorProfile(this, "Resource", {
            connectorProfileName: this.physicalName,
            connectorLabel: connectorType.asProfileConnectorLabel,
            connectorType: connectorType.asProfileConnectorType,
            connectionMode: connection_mode_1.ConnectionMode.PUBLIC,
            kmsArn: props.key && props.key.keyArn,
            connectorProfileConfig: {
                connectorProfileCredentials: this.buildConnectorProfileCredentials(props),
                connectorProfileProperties: this.buildConnectorProfileProperties(props),
            },
        });
        this.arn = resource.attrConnectorProfileArn;
        this.name = this.physicalName;
        this.credentials = aws_secretsmanager_1.Secret.fromSecretCompleteArn(this, `Credentials`, resource.attrCredentialsArn);
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.ConnectorProfileBase = ConnectorProfileBase;
_a = JSII_RTTI_SYMBOL_1;
ConnectorProfileBase[_a] = { fqn: "@cdklabs/cdk-appflow.ConnectorProfileBase", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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