import { IResource, Resource } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { IKey } from "aws-cdk-lib/aws-kms";
import { ISecret } from "aws-cdk-lib/aws-secretsmanager";
import { Construct, IConstruct } from "constructs";
import { ConnectorType } from "./connector-type";
export interface IConnectorProfile extends IResource {
    readonly name: string;
    readonly arn: string;
    readonly credentials?: ISecret;
}
export interface ConnectorProfileProps {
    readonly name?: string;
    /**
     * TODO: think if this should be here as not all connector profiles have that
     */
    readonly key?: IKey;
}
export declare abstract class ConnectorProfileBase extends Resource implements IConnectorProfile {
    /**
     * @internal
     * @experimental
     */
    protected static _fromConnectorProfileAttributes(scope: Construct, id: string, attrs: {
        name?: string;
        arn?: string;
    }): IConnectorProfile;
    readonly arn: string;
    readonly credentials?: ISecret;
    readonly name: string;
    constructor(scope: Construct, id: string, props: ConnectorProfileProps, connectorType: ConnectorType);
    protected abstract buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
    protected abstract buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected tryAddNodeDependency(scope: IConstruct, resource?: IConstruct | string): void;
}
