import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { AsanaConnectorProfile } from "./profile";
import { ConnectorType } from "../core/connectors/connector-type";
import { IFlow } from "../core/flows";
import { ISource } from "../core/vertices";
export interface AsanaSourceProps {
    readonly profile: AsanaConnectorProfile;
    readonly object: string;
    readonly apiVersion?: string;
}
/**
 * A class that represents a Asana v3 Source
 */
export declare class AsanaSource implements ISource {
    private readonly props;
    private static readonly apiVersion;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: AsanaSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
