import { SecretValue } from "aws-cdk-lib";
import { CfnConnectorProfile } from "aws-cdk-lib/aws-appflow";
import { Construct } from "constructs";
import { ConnectorProfileBase, ConnectorProfileProps } from "../core/connectors/connector-profile";
export interface AsanaConnectorProfileProps extends ConnectorProfileProps {
    readonly patToken: SecretValue;
}
/**
 * A class that represents a Asana Connector Profile.
 *
 */
export declare class AsanaConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): AsanaConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): AsanaConnectorProfile;
    constructor(scope: Construct, id: string, props: AsanaConnectorProfileProps);
    protected buildConnectorProfileProperties(_props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
