"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonRdsForPostgreSqlConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const core_1 = require("../core");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * The connector profile for the Amazon RDS for PostgreSQL connector
 */
class AmazonRdsForPostgreSqlConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    /**
     * Imports an existing AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param arn the ARN for the existing connector profile
     * @returns An instance of the AmazonRdsForPostreSqlConnectorProfile
     */
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    /**
     * Imports an existing AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param name the name for the existing connector profile
     * @returns An instance of the AmazonRdsForPostreSqlConnectorProfile
     */
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    /**
     * Creates a new instance of the AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the Construct scope for this connector profile
     * @param id the id of this connector profile
     * @param props properties to use when instantiating this connector profile
     */
    constructor(scope, id, props) {
        super(scope, id, props, type_1.AmazonRdsForPostgreSqlConnectorType.instance);
    }
    buildConnectorProfileProperties(_props) {
        return {
            customConnector: {
                profileProperties: {},
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: core_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        username: properties.basicAuth.username,
                        password: properties.basicAuth.password.unsafeUnwrap(),
                        driver: "postgresql",
                        hostname: properties.hostname,
                        port: properties.port
                            ? `${properties.port}`
                            : AmazonRdsForPostgreSqlConnectorProfile.defaultPort.toString(),
                        database: properties.database,
                    },
                    customAuthenticationType: "CUSTOM",
                },
            },
        };
    }
}
exports.AmazonRdsForPostgreSqlConnectorProfile = AmazonRdsForPostgreSqlConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
AmazonRdsForPostgreSqlConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.AmazonRdsForPostgreSqlConnectorProfile", version: "0.2.1" };
AmazonRdsForPostgreSqlConnectorProfile.defaultPort = 5432;
//# sourceMappingURL=data:application/json;base64,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