"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonRdsForPostgreSqlDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const write_operation_1 = require("../core/write-operation");
/**
 * Represents a destination for the Amazon RDS for PostgreSQL connector
 */
class AmazonRdsForPostgreSqlDestination {
    /**
     * Creates a new instance of the AmazonRdsForPostgreSqlDestination
     * @param props - properties of the destination
     */
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.AmazonRdsForPostgreSqlConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion ??
                AmazonRdsForPostgreSqlDestination.defaultApiVersion,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            customConnector: {
                entityName: `${this.props.object.schema}.${this.props.object.table}`,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                writeOperationType: write_operation_1.WriteOperationType.INSERT,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.AmazonRdsForPostgreSqlDestination = AmazonRdsForPostgreSqlDestination;
_a = JSII_RTTI_SYMBOL_1;
AmazonRdsForPostgreSqlDestination[_a] = { fqn: "@cdklabs/cdk-appflow.AmazonRdsForPostgreSqlDestination", version: "0.2.1" };
AmazonRdsForPostgreSqlDestination.defaultApiVersion = "1.0";
//# sourceMappingURL=data:application/json;base64,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