"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/core/flows/flow-time-updater/flow-time-updater.lambda.ts
var flow_time_updater_lambda_exports = {};
__export(flow_time_updater_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(flow_time_updater_lambda_exports);

// src/core/flows/flow-time-updater/api.ts
var PROP_SCHEDULE = "Schedule";
var PROP_STARTTIME = "StartTime";
var PROP_ENDTIME = "EndTime";
var ATTR_SCHEDULE = "Schedule";
var ATTR_STARTTIME = "StartTime";
var ATTR_ENDTIME = "EndTime";

// src/core/flows/flow-time-updater/flow-time-updater.lambda.ts
async function handler(event) {
  switch (event.RequestType) {
    case "Create":
    case "Update":
      return updateFlowTime(event);
    case "Delete":
      return;
    default:
      throw new Error("Unknown signal");
  }
}
async function updateFlowTime(event) {
  let expressionString = event.ResourceProperties[PROP_SCHEDULE];
  const propStartTime = event.ResourceProperties[PROP_STARTTIME];
  let startTime = propStartTime ? new Date(Date.parse(propStartTime)) : void 0;
  const propEndTime = event.ResourceProperties[PROP_ENDTIME];
  let endTime = propEndTime ? new Date(Date.parse(propEndTime)) : void 0;
  if (/^rate/.test(expressionString)) {
    ({ expressionString, startTime } = buildForRateBasedSchedule(
      expressionString,
      startTime
    ));
  } else if (/^cron/.test(expressionString)) {
  } else {
    throw new Error(`Unrecognized expression ${expressionString}`);
  }
  return {
    Data: {
      [ATTR_SCHEDULE]: expressionString,
      [ATTR_STARTTIME]: startTime && startTime.getTime() / 1e3,
      [ATTR_ENDTIME]: endTime && endTime.getTime() / 1e3
    }
  };
}
function buildForRateBasedSchedule(expressionString, startTime) {
  const matches = /\((\d*)(.*)\)$/.exec(expressionString);
  if (!matches) {
    throw new Error(
      `Expression ${expressionString} is not a rate-based expression`
    );
  }
  const rate = parseFloat(matches[1]);
  let rateUnit = matches[2].trim();
  if (!rateUnit.endsWith("s")) {
    rateUnit = `${rateUnit}s`;
  }
  expressionString = `rate(${rate}${rateUnit})`;
  if (startTime) {
    const nowMillis = Date.now();
    const startMillis = startTime.getTime();
    if (nowMillis > startMillis) {
      let denominator = 1;
      switch (rateUnit) {
        case "minutes":
          denominator = 60 * 1e3;
          break;
        case "hours":
          denominator = 60 * 60 * 1e3;
          break;
        case "days":
          denominator = 24 * 60 * 60 * 1e3;
          break;
        default:
          throw new Error(`Unable to use schedule "${expressionString}"`);
      }
      const cyclesBetween = Math.ceil(
        (nowMillis - startMillis) / denominator / rate
      );
      startTime = new Date(
        (startMillis / denominator + cyclesBetween * rate) * denominator
      );
    }
  }
  return { expressionString, startTime };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
