"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineNotificationEvents = exports.Action = exports.GlobalVariables = exports.ActionCategory = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
var ActionCategory;
(function (ActionCategory) {
    ActionCategory["SOURCE"] = "Source";
    ActionCategory["BUILD"] = "Build";
    ActionCategory["TEST"] = "Test";
    ActionCategory["APPROVAL"] = "Approval";
    ActionCategory["DEPLOY"] = "Deploy";
    ActionCategory["INVOKE"] = "Invoke";
})(ActionCategory = exports.ActionCategory || (exports.ActionCategory = {}));
/**
 * The CodePipeline variables that are global,
 * not bound to a specific action.
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 */
class GlobalVariables {
}
exports.GlobalVariables = GlobalVariables;
_a = JSII_RTTI_SYMBOL_1;
GlobalVariables[_a] = { fqn: "@aws-cdk/aws-codepipeline.GlobalVariables", version: "1.146.0" };
/** The identifier of the current pipeline execution. */
GlobalVariables.executionId = '#{codepipeline.PipelineExecutionId}';
/**
 * Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 */
class Action {
    constructor() {
        this._variableReferenced = false;
        this._namespaceToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this._actualNamespace === undefined) {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
                else {
                    return this._customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this._customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this._variableReferenced ? this._actualNamespace : undefined);
                }
            },
        });
    }
    get actionProperties() {
        if (this.__actionProperties === undefined) {
            const actionProperties = this.providedActionProperties;
            this._customerProvidedNamespace = actionProperties.variablesNamespace;
            this.__actionProperties = {
                ...actionProperties,
                variablesNamespace: this._customerProvidedNamespace === undefined
                    ? this._namespaceToken
                    : this._customerProvidedNamespace,
            };
        }
        return this.__actionProperties;
    }
    bind(scope, stage, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_ActionBindOptions(options);
        this.__pipeline = stage.pipeline;
        this.__stage = stage;
        this.__scope = scope;
        this._actualNamespace = this._customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this._customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this._scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this._pipeline.pipelineArn],
            detail: {
                stage: [this._stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this._variableReferenced = true;
        return `#{${this._namespaceToken}.${variableName}}`;
    }
    get _pipeline() {
        if (this.__pipeline) {
            return this.__pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get _stage() {
        if (this.__stage) {
            return this.__stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get _scope() {
        if (this.__scope) {
            return this.__scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_b = JSII_RTTI_SYMBOL_1;
Action[_b] = { fqn: "@aws-cdk/aws-codepipeline.Action", version: "1.146.0" };
/**
 * The list of event types for AWS Codepipeline Pipeline
 * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
 */
var PipelineNotificationEvents;
(function (PipelineNotificationEvents) {
    /**
     * Trigger notification when pipeline execution failed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    /**
     * Trigger notification when pipeline execution canceled
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    /**
     * Trigger notification when pipeline execution started
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    /**
     * Trigger notification when pipeline execution resumed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    /**
     * Trigger notification when pipeline execution succeeded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    /**
     * Trigger notification when pipeline execution superseded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    /**
     * Trigger notification when pipeline stage execution started
     */
    PipelineNotificationEvents["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    /**
    * Trigger notification when pipeline stage execution succeeded
    */
    PipelineNotificationEvents["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    /**
    * Trigger notification when pipeline stage execution resumed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    /**
    * Trigger notification when pipeline stage execution canceled
    */
    PipelineNotificationEvents["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    /**
    * Trigger notification when pipeline stage execution failed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    /**
     * Trigger notification when pipeline action execution succeeded
     */
    PipelineNotificationEvents["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    /**
     * Trigger notification when pipeline action execution failed
     */
    PipelineNotificationEvents["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    /**
     * Trigger notification when pipeline action execution canceled
     */
    PipelineNotificationEvents["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    /**
     * Trigger notification when pipeline action execution started
     */
    PipelineNotificationEvents["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    /**
     * Trigger notification when pipeline manual approval failed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    /**
     * Trigger notification when pipeline manual approval needed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    /**
     * Trigger notification when pipeline manual approval succeeded
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineNotificationEvents = exports.PipelineNotificationEvents || (exports.PipelineNotificationEvents = {}));
//# sourceMappingURL=data:application/json;base64,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