"""introduce experience index

Revision ID: a113f2ab4dc9
Revises: 05e3da68582b
Create Date: 2023-11-09 10:33:53.610165

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel


# revision identifiers, used by Alembic.
revision: str = "a113f2ab4dc9"
down_revision: Union[str, None] = "05e3da68582b"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "experience",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("title", sa.JSON(), nullable=True),
        sa.Column("description", sa.JSON(), nullable=True),
        sa.Column(
            "structure",
            sa.Enum(
                "ATOMIC",
                "COLLECTION",
                "NETWORKED",
                "HIERARCHICAL",
                "LINEAR",
                name="structure",
            ),
            nullable=True,
        ),
        sa.Column(
            "aggregation_level",
            sa.Enum("ONE", "TWO", "THREE", "FOUR", name="aggregationlevel"),
            nullable=True,
        ),
        sa.Column("format", sa.JSON(), nullable=True),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("iri", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "language", sqlmodel.sql.sqltypes.AutoString(length=100), nullable=False
        ),
        sa.Column("duration", sa.Integer(), nullable=True),
        sa.CheckConstraint("duration >= 0", name="positive-duration"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("iri"),
    )
    op.create_table(
        "relation",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "kind",
            sa.Enum(
                "ISPARTOF",
                "HASPART",
                "ISVERSIONOF",
                "HASVERSION",
                "ISFORMATOF",
                "HASFORMAT",
                "REFERENCES",
                "ISREFERENCEDBY",
                "ISBASEDON",
                "ISBASISFOR",
                "REQUIRES",
                "ISREQUIREDBY",
                name="relationtype",
            ),
            nullable=True,
        ),
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("source_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("target_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.CheckConstraint("source_id != target_id", name="no-self-referential"),
        sa.ForeignKeyConstraint(
            ["source_id"],
            ["experience.id"],
        ),
        sa.ForeignKeyConstraint(
            ["target_id"],
            ["experience.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("source_id", "target_id", "kind"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("relation")
    op.drop_table("experience")
    # ### end Alembic commands ###
