"""update cache index

Revision ID: 05e3da68582b
Revises: 58a5b4238bbc
Create Date: 2023-11-09 10:09:55.063434

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "05e3da68582b"
down_revision: Union[str, None] = "58a5b4238bbc"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "cacheentry",
        "created_at",
        existing_type=postgresql.TIMESTAMP(timezone=True),
        nullable=True,
    )
    op.drop_index("ix_cache_key", table_name="cacheentry")
    op.create_index(op.f("ix_cacheentry_key"), "cacheentry", ["key"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_cacheentry_key"), table_name="cacheentry")
    op.create_index("ix_cache_key", "cacheentry", ["key"], unique=False)
    op.alter_column(
        "cacheentry",
        "created_at",
        existing_type=postgresql.TIMESTAMP(timezone=True),
        nullable=False,
    )
    # ### end Alembic commands ###
