import logging  # noqa: INP001
import sqlite3

from .table import QolsysTable

LOGGER = logging.getLogger(__name__)


class QolsysTableZwaveNode(QolsysTable):

    def __init__(self, db: sqlite3.Connection, cursor: sqlite3.Cursor) -> None:
        super().__init__(db, cursor)
        self._uri = "content://com.qolsys.qolsysprovider.ZwaveContentProvider/zwave_node"
        self._table = "zwave_node"
        self._abort_on_error = True

        self._columns = [
            "_id",
            "version",
            "opr TEXT",
            "partition_id",
            "node_id",
            "node_name",
            "node_type",
            "node_status",
            "node_secure_cmd_cls",
            "node_battery_level",
            "node_battery_level_value",
            "is_node_listening_node",
            "basic_report_value",
            "switch_multilevel_report_value",
            "basic_device_type",
            "generic_device_type",
            "specific_device_type",
            "num_secure_command_class",
            "secure_command_class",
            "manufacture_id",
            "product_type",
            "product_id",
            "library_type_version",
            "protocol_version",
            "protocol_sub_version",
            "application_version",
            "application_sub_version",
            "capability",
            "command_class_list",
            "lenof_command_class_list",
            "security",
            "library_type",
            "last_updated_date",
            "node_battery_level_updated_time",
            "basic_report_updated_time",
            "switch_multilevel_report_updated_time",
            "multi_channel_details",
            "rediscover_status",
            "last_rediscover_time",
            "neighbour_info",
            "last_node_test_time",
            "endpoint",
            "endpoint_details",
            "device_wakeup_time",
            "role_type",
            "is_device_sleeping",
            "counters_passed",
            "counters_failed",
            "group_id",
            "command_classes_version",
            "paired_status",
            "device_dsk",
            "endpoint_secure_cmd_cls",
            "s2_security_keys",
            "device_protocol",
            "is_device_hidden",
            "ime_data",
        ]

        self._create_table()

    def insert(self, data: dict) -> None:
        self._cursor.execute(
            f"""INSERT INTO {self.table} (_id,version,opr,partition_id,node_id,node_name,node_type,node_status,
            node_secure_cmd_cls,node_battery_level,node_battery_level_value,is_node_listening_node,basic_report_value,
            switch_multilevel_report_value,basic_device_type,generic_device_type,specific_device_type,num_secure_command_class,
            secure_command_class,manufacture_id,product_type,product_id,library_type_version,protocol_version,protocol_sub_version,
            application_version,application_sub_version,capability,command_class_list,lenof_command_class_list,security,library_type,
            last_updated_date,node_battery_level_updated_time,basic_report_updated_time,switch_multilevel_report_updated_time,
            multi_channel_details,rediscover_status,last_rediscover_time,neighbour_info,last_node_test_time,endpoint,endpoint_details,
            device_wakeup_time,role_type,is_device_sleeping,counters_passed,counters_failed,group_id,command_classes_version,
            paired_status,device_dsk,endpoint_secure_cmd_cls,s2_security_keys,device_protocol,is_device_hidden,ime_data)
              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,
            ?,?,?,?,?,?,?,?)""",
            (
                            data.get("_id"),
                            data.get("version", ""),
                            data.get("opr", ""),
                            data.get("partition_id", ""),
                            data.get("node_id", ""),
                            data.get("node_name", ""),
                            data.get("node_type", ""),
                            data.get("node_status", ""),
                            data.get("node_secure_cmd_cls", ""),
                            data.get("node_battery_level", ""),
                            data.get("node_battery_level_value", ""),
                            data.get("is_node_listening_node", ""),
                            data.get("basic_report_value", ""),
                            data.get("switch_multilevel_report_value", ""),
                            data.get("basic_device_type", ""),
                            data.get("generic_device_type", ""),
                            data.get("specific_device_type", ""),
                            data.get("num_secure_command_class", ""),
                            data.get("secure_command_class", ""),
                            data.get("manufacture_id", ""),
                            data.get("product_type", ""),
                            data.get("product_id", ""),
                            data.get("library_type_version", ""),
                            data.get("protocol_version", ""),
                            data.get("protocol_sub_version", ""),
                            data.get("application_version", ""),
                            data.get("application_sub_version", ""),
                            data.get("capability", ""),
                            data.get("command_class_list", ""),
                            data.get("lenof_command_class_list", ""),
                            data.get("security", ""),
                            data.get("library_type", ""),
                            data.get("last_updated_date", ""),
                            data.get("node_battery_level_updated_time", ""),
                            data.get("basic_report_updated_time", ""),
                            data.get("switch_multilevel_report_updated_time", ""),
                            data.get("multi_channel_details", ""),
                            data.get("rediscover_status", ""),
                            data.get("last_rediscover_time", ""),
                            data.get("neighbour_info", ""),
                            data.get("last_node_test_time", ""),
                            data.get("endpoint", ""),
                            data.get("endpoint_details", ""),
                            data.get("device_wakeup_time", ""),
                            data.get("role_type", ""),
                            data.get("is_device_sleeping", ""),
                            data.get("counters_passed", ""),
                            data.get("counters_failed", ""),
                            data.get("group_id", ""),
                            data.get("command_classes_version", ""),
                            data.get("paired_status", ""),
                            data.get("device_dsk", ""),
                            data.get("endpoint_secure_cmd_cls", ""),
                            data.get("s2_security_keys", ""),
                            data.get("device_protocol", ""),
                            data.get("is_device_hidden", ""),
                            data.get("ime_data", "")))
        self._db.commit()
