# Whipstaff

[project] | [code] | [tracker] | [pypi]

*Whipstaff* is a command-line tool for operating one or more Liberty
Deckplan Hosts (LDHs) from your local session. The reference
implementation for an LDH operator toolkit.

## Installation

The preferred way to install Whipstaff is with your package manager.
The recommended package name is `ldh-operator`. For example:

```bash
sudo apt install ldh-operator # Debian-based
```

or

```bash
pipx install ldh-operator # Python-based
```

## Usage

For help and a list of available commands:

```bash
whipstaff --help
```

## Installation (from source)

If you'd prefer to run from source...

1. Install Python 3.x and pipenv. (See
   <https://docs.pipenv.org/install/> for a tutorial.)

2. Get source:

        git clone https://source.puri.sm/liberty/tool/operator.git ldh_operator_toolkit

3. Install with pipenv:

        cd ldh_operator_toolkit
        pipenv install --dev -e .

## Usage (from source)

```bash
cd ldh_operator_toolkit
pipenv run whipstaff --help
# using "pipenv run" avoids confusion with a regular installation
```

## Build wheel package (and optionally upload)

Follow these instructions to build Liberty CLI as a Python package:

```bash
git clone https://source.puri.sm/liberty/tool/operator.git ldh_operator_toolkit
cd ldh_operator_toolkit
pipenv install --dev
pipenv shell
# optionally edit default.yaml
python setup.py sdist bdist_wheel
```

If everything works as expected you should end up with the files:

* `dist/ldh_operator-<version>-py3-none-any.whl`
* `dist/ldh_operator-<version>.tar.gz`

You can now optionally upload the created Python package to PyPI using twine:

```bash
twine upload dist/*
```

## Sharing and contributions

Whipstaff (LDH operator toolkit)  
<https://source.puri.sm/liberty/tool/operator>  
Copyright 2018-2020 Purism SPC  
SPDX-License-Identifier: AGPL-3.0-or-later  

Shared under AGPL-3.0-or-later. We adhere to the Community Covenant
1.0 without modification, and certify origin per DCO 1.1 with a
signed-off-by line. Contributions under the same terms are welcome.

For details see:

* [COPYING.AGPL.md], full license text
* [CODE_OF_CONDUCT.md], full conduct text
* [CONTRIBUTING.DCO.md], full origin text

<!-- Links -->

[project]: https://source.puri.sm/liberty/tool/operator
[code]: https://source.puri.sm/liberty/tool/operator/tree/master
[tracker]: https://source.puri.sm/liberty/tool/operator/issues
[pypi]: https://pypi.org/project/ldh-operator/
[SETUP.md]: SETUP.md
[COPYING.AGPL.md]: COPYING.AGPL.md
[CODE_OF_CONDUCT.md]: CODE_OF_CONDUCT.md
[CONTRIBUTING.DCO.md]: CONTRIBUTING.DCO.md
[COPYING.md]: COPYING.md
[CONTRIBUTING.md]: CONTRIBUTING.md
