# Copyright (c) 2019 Ezybaas by Bhavik Shah.
# Susthitsoft Technologies Private Limited.
# All rights reserved.
# Please see the LICENSE.txt included as part of this package.

import os

direc = os.path.dirname(__file__)
# file_path = os.path.abspath(os.path.join(direc, '..', 'django-ezybaas'))
file_path = os.path.abspath(os.path.join(direc, '..', 'ezybaas-package'))

#Write to Readme
readme_path = os.path.abspath(os.path.join(file_path,'README.rst'))
file = open(readme_path, 'w')
file.write("EzyBaaS\n")
file.write("-----------\n")
file.write("\n")
file.write("EzyBaaS is a simple Django app to create RESTful APIs without writing any Server Side Code.\n")
file.write("Detailed documentation is in the docs directory.\n")
file.write("\n")
file.write("Quick start\n")
file.write("-----------\n")
file.write("\n")
file.write("1. Add ezybaas to your INSTALLED_APPS setting like this:\n")
file.write("\n")
file.write("\tINSTALLED_APPS = [\n")
file.write("\t...	\n")
file.write("\t'ezybaas',\n")
file.write("\t]\n")
file.write("\n")
file.write("2. Include the ezybaas URLconf in your project urls.py like this:\n")
file.write("\n")
file.write("\tpath('ezybaas/', include('ezybaas.urls')),\n")
file.write("\n")
file.write("3. Run `python manage.py migrate` to create the ezybaas models.\n")
file.write("\n")
file.write("4. Start the development server and visit http://127.0.0.1:8000/admin/ (you'll need the Admin app enabled).\n")
file.write("\n")
file.write("5. Visit http://127.0.0.1:8000/ezybaas/.\n")
file.write("\n")
file.write("6. Create superuser \n")
file.close()

#License
license_path = os.path.abspath(os.path.join(file_path,'LICENSE'))
file = open(license_path, 'w')
file.write("\n")
file.write("BSD 3-Clause License\n")
file.write("Copyright (c) 2019, Susthitsoft Technologies\n")
file.write("All rights reserved.\n")
file.write("\n")
file.write("Redistribution and use in source and binary forms, with or without\n")
file.write("modification, are permitted provided that the following conditions are met:\n")
file.write("\n")
file.write("1. Redistributions of source code must retain the above copyright notice, this\n")
file.write("list of conditions and the following disclaimer.\n")
file.write("\n")
file.write("2. Redistributions in binary form must reproduce the above copyright notice,\n")
file.write("this list of conditions and the following disclaimer in the documentation\n")
file.write("and/or other materials provided with the distribution.\n")
file.write("\n")
file.write("3. Neither the name of the copyright holder nor the names of its\n")
file.write("contributors may be used to endorse or promote products derived from\n")
file.write("this software without specific prior written permission.\n")
file.write("\n")
file.write("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 'AS IS'\n")
file.write("AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n")
file.write("IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n")
file.write("DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE\n")
file.write("FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n")
file.write("DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\n")
file.write("SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\n")
file.write("CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\n")
file.write("OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n")
file.write("OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n")

# Setup File
setup_path = os.path.abspath(os.path.join(file_path,'setup.py'))
file = open(setup_path, 'w')
file.write("import os\n")
file.write("from setuptools import find_packages, setup\n")
file.write("\n")
file.write("with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:\n")
file.write("    README = readme.read()\n")
file.write("\n")
file.write("# allow setup.py to be run from any path\n")
file.write("os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))\n")
file.write("\n")
file.write("setup(\n")
file.write("    name='susthitsoft_ezybaas',\n")
file.write("    version='0.1',\n")
file.write("    packages=find_packages(),\n")
file.write("    include_package_data=True,\n")
file.write("    license='BSD License',  # example license\n")
file.write("    description='A simple Django app to create RESTful APIs.',\n")
file.write("    long_description=README,\n")
file.write("    url='https://www.appkaro.com/',\n")
file.write("    author='Your Name',\n")
file.write("    author_email='yourname@example.com',\n")
file.write("    classifiers=[\n")
file.write("        'Environment :: Web Environment',\n")
file.write("        'Framework :: Django',\n")
file.write("        'Framework :: Django :: 2.2',  # replace 'X.Y' as appropriate\n")
file.write("        'Intended Audience :: Developers',\n")
file.write("        'License :: OSI Approved :: BSD License',  # example license\n")
file.write("        'Operating System :: OS Independent',\n")
file.write("        'Programming Language :: Python',\n")
file.write("        'Programming Language :: Python :: 3.5',\n")
file.write("        'Programming Language :: Python :: 3.6',\n")
file.write("        'Topic :: Internet :: WWW/HTTP',\n")
file.write("        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',\n")
file.write("    ],\n")
file.write(")\n")
