# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ImageSpriteConfig(object):

    def __init__(self, rows, columns, startTime=None, intervalTime=None, frameType=None, format=None, cellWidth=None, cellHeight=None, doKeepShots=None):
        """
        :param startTime: (Optional) 截图起始时间，单位：秒
        :param intervalTime: (Optional) 截图间隔
        :param frameType: (Optional) 截图帧类型。
        :param format: (Optional) 截图格式。取值范围：jpg、png
        :param rows:  雪碧图小图行数。雪碧图行列积必须不大于100, 缺省值为 10

        :param columns:  雪碧图小图列数。雪碧图行列积必须不大于100, 缺省值为 10

        :param cellWidth: (Optional) 雪碧图单元格宽度
取值范围：[8, 4096]，不能为奇数
未设置时，回退为截图宽度 width

        :param cellHeight: (Optional) 雪碧图单元格高度，
取值范围：[8, 4096]，不能为奇数
未设置时，系统自动会自动设置为截图高度 height

        :param doKeepShots: (Optional) 是否保留截图
雪碧图的截图方式是先截取普通图，然后合成雪碧图。此字段控制是否保留截图。

        """

        self.startTime = startTime
        self.intervalTime = intervalTime
        self.frameType = frameType
        self.format = format
        self.rows = rows
        self.columns = columns
        self.cellWidth = cellWidth
        self.cellHeight = cellHeight
        self.doKeepShots = doKeepShots
