# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateInstanceTemplateRequest(JDCloudRequest):
    """
    
修改实例模板属性。

详细操作说明请参考帮助文档：[实例模板](https://docs.jdcloud.com/cn/virtual-machines/instance-template-overview)

## 接口说明
- 名称、描述、实例模板配置信息至少要传一项。
- 参数时，对应的参数不做更改。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateInstanceTemplateRequest, self).__init__(
            '/regions/{regionId}/instanceTemplates/{instanceTemplateId}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateInstanceTemplateParameters(object):

    def __init__(self, regionId,instanceTemplateId,):
        """
        :param regionId: 地域ID。
        :param instanceTemplateId: 实例模板ID。
        """

        self.regionId = regionId
        self.instanceTemplateId = instanceTemplateId
        self.name = None
        self.description = None
        self.instanceTemplateData = None

    def setName(self, name):
        """
        :param name: (Optional) 实例模板的名称，参考 [公共参数规范](https://docs.jdcloud.com/virtual-machines/api/general_parameters)。
        """
        self.name = name

    def setDescription(self, description):
        """
        :param description: (Optional) 实例模板的描述，参考 [公共参数规范](https://docs.jdcloud.com/virtual-machines/api/general_parameters)。
        """
        self.description = description

    def setInstanceTemplateData(self, instanceTemplateData):
        """
        :param instanceTemplateData: (Optional) 实例模板配置信息。
        """
        self.instanceTemplateData = instanceTemplateData

