# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstanceSpecRequest(JDCloudRequest):
    """
    修改 TiDB 实例中各类节点中的数目与规格。支持 TiDB 节点和 Monitor 节点数目和规格的同时调整。 如果当前实例无 TiFlash 和 TiCDC 节点，那么在增加 TiFlash 和 TiCDC 节点数目时，可同时指定其规格。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstanceSpecRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec', 'POST', header, version)
        self.parameters = parameters


class ModifyInstanceSpecParameters(object):

    def __init__(self,regionId, instanceId, ):
        """
        :param regionId: 地域代码
        :param instanceId: 实例ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.tikvNodeNum = None
        self.pdNodeNum = None
        self.tidbNodeSpec = None
        self.tiflashNodeSpec = None
        self.ticdcNodeSpec = None
        self.monitorNodeSpec = None

    def setTikvNodeNum(self, tikvNodeNum):
        """
        :param tikvNodeNum: (Optional) 调整后的tikv节点数
        """
        self.tikvNodeNum = tikvNodeNum

    def setPdNodeNum(self, pdNodeNum):
        """
        :param pdNodeNum: (Optional) 调整后的pd节点数
        """
        self.pdNodeNum = pdNodeNum

    def setTidbNodeSpec(self, tidbNodeSpec):
        """
        :param tidbNodeSpec: (Optional) TiDB节点规格和数目
        """
        self.tidbNodeSpec = tidbNodeSpec

    def setTiflashNodeSpec(self, tiflashNodeSpec):
        """
        :param tiflashNodeSpec: (Optional) TiFlash节点规格和数目
        """
        self.tiflashNodeSpec = tiflashNodeSpec

    def setTicdcNodeSpec(self, ticdcNodeSpec):
        """
        :param ticdcNodeSpec: (Optional) Ticdc节点规格和数目
        """
        self.ticdcNodeSpec = ticdcNodeSpec

    def setMonitorNodeSpec(self, monitorNodeSpec):
        """
        :param monitorNodeSpec: (Optional) Monitor节点规格和数目
        """
        self.monitorNodeSpec = monitorNodeSpec

