# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GrantAccountPrivilegeRequest(JDCloudRequest):
    """
    授予账号的数据库细粒度的访问权限 - 仅支持 MySQL，Percona，MariaDB
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GrantAccountPrivilegeRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/accounts/{accountName}:grantAccountPrivilege', 'POST', header, version)
        self.parameters = parameters


class GrantAccountPrivilegeParameters(object):

    def __init__(self, regionId, instanceId, accountName, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param accountName: 账号名，在同一个实例中账号名不能重复
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.accountName = accountName
        self.databasePrivileges = None
        self.globalPrivileges = None

    def setDatabasePrivileges(self, databasePrivileges):
        """
        :param databasePrivileges: (Optional) 设置数据库细粒度权限内容
        """
        self.databasePrivileges = databasePrivileges

    def setGlobalPrivileges(self, globalPrivileges):
        """
        :param globalPrivileges: (Optional) 设置全局权限，权限的具体定义参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)
        """
        self.globalPrivileges = globalPrivileges

