# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateZoneRequest(JDCloudRequest):
    """
    - 添加一个私有解析的zone，可添加以下三种类型的zone
- 云内全局zone：zone的后缀是指定的后缀，如：local。该域名在云内自动全局生效，不用关联vpc即可在vpc内解析，该类型全局唯一，不能重复添加
- 反向解析zone：zone的后缀是in-addr.arpa时，我们认为他是一个反向解析的zone，反向解析域名前缀目前支持10/172.16-31/192.168网段，如：10.in-addr.arpa、16.172.in-addr.arpa。反向解析的zone只能添加反向解析的记录
- 私有解析zone：该类型的zone可以时任意符合格式的域名，私有解析zone需要关联vpc后，在vpc内生效解析

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateZoneRequest, self).__init__(
            '/regions/{regionId}/zones', 'POST', header, version)
        self.parameters = parameters


class CreateZoneParameters(object):

    def __init__(self, regionId, zone, instanceId, zoneType, ):
        """
        :param regionId: 地域ID
        :param zone: zone
        :param instanceId: 购买的套餐实例ID
        :param zoneType: 域名类型 LOCAL->云内全局 PTR->反向解析zone PV->私有zone
        """

        self.regionId = regionId
        self.zone = zone
        self.instanceId = instanceId
        self.zoneType = zoneType
        self.retryRecurse = None
        self.bindVpc = None

    def setRetryRecurse(self, retryRecurse):
        """
        :param retryRecurse: (Optional) 解析失败后是否进行递归解析
        """
        self.retryRecurse = retryRecurse

    def setBindVpc(self, bindVpc):
        """
        :param bindVpc: (Optional) 绑定的vpc信息
        """
        self.bindVpc = bindVpc

