# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ResizePodRequest(JDCloudRequest):
    """
    调整pod实例类型配置。
- pod phase 需是停止状态；
- 支持升配、降配；**不支持原有规格**
- 计费类型不变
    - 包年包月：需要计算配置差价，如果所选配置价格高，需要补齐到期前的差价，到期时间不变；如果所选配置价格低，需要延长到期时间
    - 按配置：按照所选规格，进行计费
- 支持对 pod 中的容器进行资源限制、资源需求的调整
    - 容器需求的总资源占用不得超过 pod 的实例类型
    - 容器资源限制不得超过 pod 的实例类型

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ResizePodRequest, self).__init__(
            '/regions/{regionId}/pods/{podId}:resize', 'POST', header, version)
        self.parameters = parameters


class ResizePodParameters(object):

    def __init__(self, regionId,podId,instanceType, ):
        """
        :param regionId: Region ID
        :param podId: Pod ID
        :param instanceType: 新实例类型，不可与原实例类型相同
        """

        self.regionId = regionId
        self.podId = podId
        self.instanceType = instanceType
        self.containerResources = None

    def setContainerResources(self, containerResources):
        """
        :param containerResources: (Optional) 新实例类型，不可与原实例类型相同
        """
        self.containerResources = containerResources

