# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateNodeGroupRequest(JDCloudRequest):
    """
    创建工作节点组<br>
- 要求集群状态为running

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateNodeGroupRequest, self).__init__(
            '/regions/{regionId}/nodeGroups', 'POST', header, version)
        self.parameters = parameters


class CreateNodeGroupParameters(object):

    def __init__(self,regionId, name, clusterId, nodeConfig, initialNodeCount, ):
        """
        :param regionId: 地域 ID
        :param name: 名称（同一用户的 cluster 内部唯一）
        :param clusterId: 工作节点所属的集群
        :param nodeConfig: 工作节点配置信息
        :param initialNodeCount: 工作节点组初始化大小
        """

        self.regionId = regionId
        self.name = name
        self.description = None
        self.clusterId = clusterId
        self.nodeConfig = nodeConfig
        self.azs = None
        self.initialNodeCount = initialNodeCount
        self.caConfig = None
        self.nodeGroupNetwork = None

    def setDescription(self, description):
        """
        :param description: (Optional) 描述
        """
        self.description = description

    def setAzs(self, azs):
        """
        :param azs: (Optional) 工作节点组的 az，必须为集群az的子集，默认为集群az
        """
        self.azs = azs

    def setCaConfig(self, caConfig):
        """
        :param caConfig: (Optional) 自动伸缩配置
        """
        self.caConfig = caConfig

    def setNodeGroupNetwork(self, nodeGroupNetwork):
        """
        :param nodeGroupNetwork: (Optional) 节点组的网络配置，如果集群的类型customized类型，则必须指定该参数，如果是auto，则不是必须
        """
        self.nodeGroupNetwork = nodeGroupNetwork

