# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateViTemplateRequest(JDCloudRequest):
    """
    创建视频审查模板
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateViTemplateRequest, self).__init__(
            '/viTemplates', 'POST', header, version)
        self.parameters = parameters


class CreateViTemplateParameters(object):

    def __init__(self, templateName, inspectItems):
        """
        :param templateName: 模板名称。长度不超过128个字符。UTF-8编码。

        :param inspectItems: 审查配置，JSON格式
        """

        self.templateName = templateName
        self.shotInterval = None
        self.shotIntervalType = None
        self.shotFormat = None
        self.shotFrameType = None
        self.shotWidth = None
        self.shotHeight = None
        self.shotFillType = None
        self.inspectItems = inspectItems

    def setShotInterval(self, shotInterval):
        """
        :param shotInterval: (Optional) 截图间隔
        """
        self.shotInterval = shotInterval

    def setShotIntervalType(self, shotIntervalType):
        """
        :param shotIntervalType: (Optional) 间隔类型：time, percent
        """
        self.shotIntervalType = shotIntervalType

    def setShotFormat(self, shotFormat):
        """
        :param shotFormat: (Optional) 截图格式：png, jpg
        """
        self.shotFormat = shotFormat

    def setShotFrameType(self, shotFrameType):
        """
        :param shotFrameType: (Optional) 截图帧类型：any, key
        """
        self.shotFrameType = shotFrameType

    def setShotWidth(self, shotWidth):
        """
        :param shotWidth: (Optional) 截图宽度
        """
        self.shotWidth = shotWidth

    def setShotHeight(self, shotHeight):
        """
        :param shotHeight: (Optional) 截图高度
        """
        self.shotHeight = shotHeight

    def setShotFillType(self, shotFillType):
        """
        :param shotFillType: (Optional) 截图填充类型：stretch, gauss, black, white
        """
        self.shotFillType = shotFillType

