# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AddEdgeWithCoreRequest(JDCloudRequest):
    """
    添加Edge设备
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(AddEdgeWithCoreRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/edges/{edgeName}:addEdge', 'POST', header, version)
        self.parameters = parameters


class AddEdgeWithCoreParameters(object):

    def __init__(self, regionId, instanceId, edgeName, architecture, os, manufacturer, edgeModel, ):
        """
        :param regionId: 地域ID
        :param instanceId: IoTCore实例编号
        :param edgeName: Edge名称
        :param architecture: 硬件平台编号，具体参数参见硬件平台参数文档
        :param os: 操作系统编号，具体参数参见操作系统参数文档
        :param manufacturer: Edge厂家信息
        :param edgeModel: Edge型号信息
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.edgeName = edgeName
        self.architecture = architecture
        self.os = os
        self.manufacturer = manufacturer
        self.edgeModel = edgeModel
        self.edgeDesc = None

    def setEdgeDesc(self, edgeDesc):
        """
        :param edgeDesc: (Optional) Edge描述
        """
        self.edgeDesc = edgeDesc

