# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateFunctionRequest(JDCloudRequest):
    """
    更新函数
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateFunctionRequest, self).__init__(
            '/regions/{regionId}/functions/{functionName}', 'PUT', header, version)
        self.parameters = parameters


class UpdateFunctionParameters(object):

    def __init__(self, regionId, functionName, ):
        """
        :param regionId: Region ID
        :param functionName: 函数名称
        """

        self.regionId = regionId
        self.functionName = functionName
        self.description = None
        self.entrance = None
        self.memory = None
        self.runTime = None
        self.overTime = None
        self.version = None
        self.code = None
        self.environment = None
        self.logSetId = None
        self.logTopicId = None
        self.vpcId = None
        self.subnetId = None

    def setDescription(self, description):
        """
        :param description: (Optional) 函数描述信息
        """
        self.description = description

    def setEntrance(self, entrance):
        """
        :param entrance: (Optional) 函数入口，格式为入口文件.入口函数名
        """
        self.entrance = entrance

    def setMemory(self, memory):
        """
        :param memory: (Optional) 函数运行最大内存
        """
        self.memory = memory

    def setRunTime(self, runTime):
        """
        :param runTime: (Optional) 函数运行环境
        """
        self.runTime = runTime

    def setOverTime(self, overTime):
        """
        :param overTime: (Optional) 函数运行超时时间
        """
        self.overTime = overTime

    def setVersion(self, version):
        """
        :param version: (Optional) 函数版本
        """
        self.version = version

    def setCode(self, code):
        """
        :param code: (Optional) 函数代码包
        """
        self.code = code

    def setEnvironment(self, environment):
        """
        :param environment: (Optional) 函数运行时环境变量
        """
        self.environment = environment

    def setLogSetId(self, logSetId):
        """
        :param logSetId: (Optional) 函数指定的日志集Id
        """
        self.logSetId = logSetId

    def setLogTopicId(self, logTopicId):
        """
        :param logTopicId: (Optional) 函数指定的日志主题Id
        """
        self.logTopicId = logTopicId

    def setVpcId(self, vpcId):
        """
        :param vpcId: (Optional) 函数配置的VPCId
        """
        self.vpcId = vpcId

    def setSubnetId(self, subnetId):
        """
        :param subnetId: (Optional) 函数配置的子网Id
        """
        self.subnetId = subnetId

