# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DeleteImageRequest(JDCloudRequest):
    """
    删除镜像
imageDigest imageTag imageTagStatus 三者只能且必须传一个。
可根据Tag状态删除Image，例如删除所有tagged的镜像。
digest和tag唯一表征单个镜像，其中imageDigest为sha256哈希，image manifest的digest。
例如 sha256:examplee6d1e504117a17000003d3753086354a38375961f2e665416ef4b1b2f；image使用的tag, 如  "precise" 
 [MFA enabled]
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DeleteImageRequest, self).__init__(
            '/regions/{regionId}/registries/{registryName}/repositories/{repositoryName}:deleteImage', 'POST', header, version)
        self.parameters = parameters


class DeleteImageParameters(object):

    def __init__(self, regionId, registryName, repositoryName, ):
        """
        :param regionId: Region ID
        :param registryName: 注册表名称
        :param repositoryName: 镜像仓库表名称
        """

        self.regionId = regionId
        self.registryName = registryName
        self.repositoryName = repositoryName
        self.imageDigest = None
        self.imageTag = None
        self.imageTagStatus = None

    def setImageDigest(self, imageDigest):
        """
        :param imageDigest: (Optional) sha256哈希，image manifest的digest.
        """
        self.imageDigest = imageDigest

    def setImageTag(self, imageTag):
        """
        :param imageTag: (Optional) image使用的tag
        """
        self.imageTag = imageTag

    def setImageTagStatus(self, imageTagStatus):
        """
        :param imageTagStatus: (Optional) 枚举中的一个值，如 tagged 和 untagged.
        """
        self.imageTagStatus = imageTagStatus

