# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GetDomainsRequest(JDCloudRequest):
    """
    获取用户所属的主域名列表。   
请在调用域名相关的接口之前，调用此接口获取相关的domainId和domainName。  
主域名的相关概念，请查阅<a href="https://docs.jdcloud.com/cn/jd-cloud-dns/product-overview">云解析文档</a>

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GetDomainsRequest, self).__init__(
            '/regions/{regionId}/domain', 'GET', header, version)
        self.parameters = parameters


class GetDomainsParameters(object):

    def __init__(self, regionId, pageNumber, pageSize, ):
        """
        :param regionId: 实例所属的地域ID
        :param pageNumber: 分页查询时查询的每页的序号，起始值为1，默认为1
        :param pageSize: 分页查询时设置的每页行数，默认为10
        """

        self.regionId = regionId
        self.pageNumber = pageNumber
        self.pageSize = pageSize
        self.domainName = None

    def setDomainName(self, domainName):
        """
        :param domainName: (Optional) 关键字，按照”%domainName%”模式匹配主域名
        """
        self.domainName = domainName

