# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstanceSpecRequest(JDCloudRequest):
    """
    Clickhouse实例变配
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstanceSpecRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec', 'POST', header, version)
        self.parameters = parameters


class ModifyInstanceSpecParameters(object):

    def __init__(self, regionId,instanceId,):
        """
        :param regionId: 地域代码
        :param instanceId: 实例ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.chNodeClass = None
        self.zkNodeClass = None
        self.chNodeStorageGB = None
        self.monitorNodeClass = None

    def setChNodeClass(self, chNodeClass):
        """
        :param chNodeClass: (Optional) clickhouse实例规格
        """
        self.chNodeClass = chNodeClass

    def setZkNodeClass(self, zkNodeClass):
        """
        :param zkNodeClass: (Optional) zookeeper实例规格
        """
        self.zkNodeClass = zkNodeClass

    def setChNodeStorageGB(self, chNodeStorageGB):
        """
        :param chNodeStorageGB: (Optional) clickhouse实例磁盘大小(GB)
        """
        self.chNodeStorageGB = chNodeStorageGB

    def setMonitorNodeClass(self, monitorNodeClass):
        """
        :param monitorNodeClass: (Optional) 监控实例规格
        """
        self.monitorNodeClass = monitorNodeClass

