# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ProtectionRuleSpec(object):

    def __init__(self, ip=None, type=None, cleanThresholdBps=None, cleanThresholdPps=None, spoofIpEnable=None, srcNewConnLimitEnable=None, srcNewConnLimitValue=None, dstNewConnLimitEnable=None, dstNewConnLimitValue=None, datagramRangeMin=None, datagramRangeMax=None, geoBlackList=None, ipBlackList=None, ipWhiteList=None):
        """
        :param ip: (Optional) 被防护 IP, 缺省时修改防护包实例防护规则
        :param type: (Optional) 防护规则类型, 修改 ip 防护规则时必传, 0: 设置 ip 使用防护包规则, 1: 设置 IP 使用自定义规则
        :param cleanThresholdBps: (Optional) 清洗触发值 bps, 修改实例防护规则或自定义 IP 防护规则时必传
        :param cleanThresholdPps: (Optional) 清洗触发值 pps, 修改实例防护规则或自定义 IP 防护规则时必传
        :param spoofIpEnable: (Optional) 虚假源, 0: 关闭, 1: 开启, 修改实例防护规则或自定义 IP 防护规则时必传
        :param srcNewConnLimitEnable: (Optional) 源新建连接限速, 0: 关闭, 1: 开启, 修改实例防护规则或自定义 IP 防护规则时必传
        :param srcNewConnLimitValue: (Optional) 源新建连接速率, 修改实例防护规则或自定义 IP 防护规则时必传
        :param dstNewConnLimitEnable: (Optional) 目的新建连接, 0: 关闭, 1: 开启, 修改实例防护规则或自定义 IP 防护规则时必传
        :param dstNewConnLimitValue: (Optional) 目的新建连接速率, 修改实例防护规则或自定义 IP 防护规则时必传
        :param datagramRangeMin: (Optional) 报文最小长度, 取值范围 [1, datagramRangeMax)
        :param datagramRangeMax: (Optional) 报文最大长度, 取值范围 (datagramRangeMin, 1518]
        :param geoBlackList: (Optional) geo 拦截地域编码列表. 查询 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describegeoareas'>describeGeoAreas</a> 接口获取可设置的地域编码列表
        :param ipBlackList: (Optional) IP 黑名单列表
        :param ipWhiteList: (Optional) IP 白名单列表
        """

        self.ip = ip
        self.type = type
        self.cleanThresholdBps = cleanThresholdBps
        self.cleanThresholdPps = cleanThresholdPps
        self.spoofIpEnable = spoofIpEnable
        self.srcNewConnLimitEnable = srcNewConnLimitEnable
        self.srcNewConnLimitValue = srcNewConnLimitValue
        self.dstNewConnLimitEnable = dstNewConnLimitEnable
        self.dstNewConnLimitValue = dstNewConnLimitValue
        self.datagramRangeMin = datagramRangeMin
        self.datagramRangeMax = datagramRangeMax
        self.geoBlackList = geoBlackList
        self.ipBlackList = ipBlackList
        self.ipWhiteList = ipWhiteList
