# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeAttackStatisticsRequest(JDCloudRequest):
    """
    攻击记录统计, 参数 ip 优先级大于 instanceId. <br>- 指定 ip 参数时, 忽略 instanceId 参数, 统计 ip 的攻击情况. <br>- 未指定 ip 时, 统计 instanceId 指定实例相关攻击情况. <br>- ip 和 instanceId 均未指定时, 查询用户所有公网 IP 攻击情况
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeAttackStatisticsRequest, self).__init__(
            '/describeAttackStatistics', 'GET', header, version)
        self.parameters = parameters


class DescribeAttackStatisticsParameters(object):

    def __init__(self, startTime, endTime, ):
        """
        :param startTime: 开始时间, 只能查询最近 90 天以内的数据, UTC 时间, 格式: yyyy-MM-dd'T'HH:mm:ssZ
        :param endTime: 结束时间, UTC 时间, 格式: yyyy-MM-dd'T'HH:mm:ssZ
        """

        self.startTime = startTime
        self.endTime = endTime
        self.instanceId = None
        self.ip = None

    def setInstanceId(self, instanceId):
        """
        :param instanceId: (Optional) 防护包实例 Id
        """
        self.instanceId = instanceId

    def setIp(self, ip):
        """
        :param ip: (Optional) DDoS 防护包已防护的公网 IP. <br>- 使用 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describeprotectediplist'>describeProtectedIpList</a> 接口查询 DDoS 防护包已防护的公网 IP
        """
        self.ip = ip

