// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0

// Abstract primitives wrapper.
//
// This file is a stop-gap until the DV file list is generated by FuseSoC.
// Its contents are taken from the file which would be generated by FuseSoC.
// https://github.com/lowRISC/ibex/issues/893

module prim_ram_1p import prim_ram_1p_pkg::*;

#(

  parameter  int Width           = 32, // bit
  parameter  int Depth           = 128,
  parameter  int DataBitsPerMask = 1, // Number of data bits per bit of write mask
  parameter      MemInitFile     = "", // VMEM file to initialize the memory width

  localparam int Aw              = $clog2(Depth)  // derived parameter

) (
  input  logic             clk_i,
  input  ram_1p_cfg_t      cfg_i,

  input  logic             req_i,
  input  logic             write_i,
  input  logic [Aw-1:0]    addr_i,
  input  logic [Width-1:0] wdata_i,
  input  logic [Width-1:0] wmask_i,
  output logic [Width-1:0] rdata_o // Read data. Data is returned one cycle after req_i is high.
);

  if (1) begin : gen_generic
    prim_generic_ram_1p #(
      .Depth(Depth),
      .MemInitFile(MemInitFile),
      .Width(Width),
      .DataBitsPerMask(DataBitsPerMask)
    ) u_impl_generic (
      .*
    );

  end

endmodule
