"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsSendMessage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 */
class SqsSendMessage extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_SqsSendMessageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS);
        if (props.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.messageBody)) {
                throw new Error('Task Token is required in `messageBody` Use JsonPath.taskToken to set the token.');
            }
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['sqs:SendMessage'],
                resources: [this.props.queue.queueArn],
            }),
        ];
    }
    /**
     * Provides the SQS SendMessage service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _b;
        return {
            Resource: task_utils_1.integrationResourceArn('sqs', 'sendMessage', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueueUrl: this.props.queue.queueUrl,
                MessageBody: this.props.messageBody.value,
                DelaySeconds: (_b = this.props.delay) === null || _b === void 0 ? void 0 : _b.toSeconds(),
                MessageDeduplicationId: this.props.messageDeduplicationId,
                MessageGroupId: this.props.messageGroupId,
            }),
        };
    }
}
exports.SqsSendMessage = SqsSendMessage;
_a = JSII_RTTI_SYMBOL_1;
SqsSendMessage[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.SqsSendMessage", version: "1.156.1" };
SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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