"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersDeleteVirtualCluster = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Deletes an EMR Containers virtual cluster as a Task.
 *
 * @see https://docs.amazonaws.cn/en_us/step-functions/latest/dg/connect-emr-eks.html
 */
class EmrContainersDeleteVirtualCluster extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrContainersDeleteVirtualClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EmrContainersDeleteVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('emr-containers', 'deleteVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Id: this.props.virtualClusterId.value,
            }),
        };
    }
    ;
    createPolicyStatements() {
        const actions = ['emr-containers:DeleteVirtualCluster'];
        if (this.integrationPattern === sfn.IntegrationPattern.RUN_JOB) {
            actions.push('emr-containers:DescribeVirtualCluster');
        }
        return [new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        arnFormat: cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME,
                        service: 'emr-containers',
                        resource: 'virtualclusters',
                        resourceName: sfn.JsonPath.isEncodedJsonPath(this.props.virtualClusterId.value) ? '*' : this.props.virtualClusterId.value,
                    }),
                ],
                actions: actions,
            })];
    }
}
exports.EmrContainersDeleteVirtualCluster = EmrContainersDeleteVirtualCluster;
_a = JSII_RTTI_SYMBOL_1;
EmrContainersDeleteVirtualCluster[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrContainersDeleteVirtualCluster", version: "1.156.1" };
EmrContainersDeleteVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
//# sourceMappingURL=data:application/json;base64,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