"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersCreateVirtualCluster = exports.EksClusterInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Class for supported types of EMR Containers' Container Providers
 */
var ContainerProviderTypes;
(function (ContainerProviderTypes) {
    /**
     * Supported container provider type for a EKS Cluster
     */
    ContainerProviderTypes["EKS"] = "EKS";
})(ContainerProviderTypes || (ContainerProviderTypes = {}));
/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 */
class EksClusterInput {
    /**
     * Initializes the clusterName
     *
     * @param clusterName The name of the EKS Cluster
     */
    constructor(clusterName) {
        this.clusterName = clusterName;
    }
    /**
     * Specify an existing EKS Cluster as the name for this Cluster
     */
    static fromCluster(cluster) {
        return new EksClusterInput(cluster.clusterName);
    }
    /**
     * Specify a Task Input as the name for this Cluster
     */
    static fromTaskInput(taskInput) {
        return new EksClusterInput(taskInput.value);
    }
}
exports.EksClusterInput = EksClusterInput;
_a = JSII_RTTI_SYMBOL_1;
EksClusterInput[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EksClusterInput", version: "1.156.1" };
/**
 * Task that creates an EMR Containers virtual cluster from an EKS cluster
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html
 */
class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _c;
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.integrationPattern = (_c = props.integrationPattern) !== null && _c !== void 0 ? _c : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        var _c, _d;
        return {
            Resource: task_utils_1.integrationResourceArn('emr-containers', 'createVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Name: (_c = this.props.virtualClusterName) !== null && _c !== void 0 ? _c : sfn.JsonPath.stringAt('States.Format(\'{}/{}\', $$.Execution.Name, $$.State.Name)'),
                ContainerProvider: {
                    Id: this.props.eksCluster.clusterName,
                    Info: {
                        EksInfo: {
                            Namespace: (_d = this.props.eksNamespace) !== null && _d !== void 0 ? _d : 'default',
                        },
                    },
                    Type: ContainerProviderTypes.EKS,
                },
                Tags: this.props.tags,
            }),
        };
    }
    ;
    createPolicyStatements() {
        return [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateVirtualCluster'],
            }),
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'iam',
                        region: '',
                        resource: 'role/aws-service-role/emr-containers.amazonaws.com',
                        resourceName: 'AWSServiceRoleForAmazonEMRContainers',
                    }),
                ],
                actions: ['iam:CreateServiceLinkedRole'],
                conditions: {
                    StringLike: { 'iam:AWSServiceName': 'emr-containers.amazonaws.com' },
                },
            }),
        ];
    }
}
exports.EmrContainersCreateVirtualCluster = EmrContainersCreateVirtualCluster;
_b = JSII_RTTI_SYMBOL_1;
EmrContainersCreateVirtualCluster[_b] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrContainersCreateVirtualCluster", version: "1.156.1" };
EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,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