"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call HTTP API endpoint as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = this.props.apiStack;
        return `${this.props.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { apiId, stageName, method, apiPath } = this.props;
        return this.props.apiStack.formatArn({
            service: 'execute-api',
            resource: apiId,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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