"""
    CCF-API

    This API provides programmatic access to data registered to the CCF. See the [HuBMAP CCF Portal](https://hubmapconsortium.github.io/ccf/) for details.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ccf_openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from ccf_openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ccf_openapi_client.model.aggregate_count import AggregateCount
from ccf_openapi_client.model.database_status import DatabaseStatus
from ccf_openapi_client.model.min_max import MinMax
from ccf_openapi_client.model.ontology_tree import OntologyTree
from ccf_openapi_client.model.spatial_entity import SpatialEntity
from ccf_openapi_client.model.spatial_scene_node import SpatialSceneNode
from ccf_openapi_client.model.tissue_block import TissueBlock


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.aggregate_results_endpoint = _Endpoint(
            settings={
                'response_type': ([AggregateCount],),
                'auth': [],
                'endpoint_path': '/aggregate-results',
                'operation_id': 'aggregate_results',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.cell_type_term_occurences_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (int,)},),
                'auth': [],
                'endpoint_path': '/cell-type-term-occurences',
                'operation_id': 'cell_type_term_occurences',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.cell_type_tree_model_endpoint = _Endpoint(
            settings={
                'response_type': (OntologyTree,),
                'auth': [],
                'endpoint_path': '/cell-type-tree-model',
                'operation_id': 'cell_type_tree_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.db_status_endpoint = _Endpoint(
            settings={
                'response_type': (DatabaseStatus,),
                'auth': [],
                'endpoint_path': '/db-status',
                'operation_id': 'db_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gtex_rui_locations_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/gtex/rui_locations.jsonld',
                'operation_id': 'gtex_rui_locations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                },
                'attribute_map': {
                    'cache': 'cache',
                },
                'location_map': {
                    'cache': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.hubmap_rui_locations_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/hubmap/rui_locations.jsonld',
                'operation_id': 'hubmap_rui_locations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ontology_term_occurences_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (int,)},),
                'auth': [],
                'endpoint_path': '/ontology-term-occurences',
                'operation_id': 'ontology_term_occurences',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ontology_tree_model_endpoint = _Endpoint(
            settings={
                'response_type': (OntologyTree,),
                'auth': [],
                'endpoint_path': '/ontology-tree-model',
                'operation_id': 'ontology_tree_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.provider_names_endpoint = _Endpoint(
            settings={
                'response_type': ([str],),
                'auth': [],
                'endpoint_path': '/provider-names',
                'operation_id': 'provider_names',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reference_organ_scene_endpoint = _Endpoint(
            settings={
                'response_type': ([SpatialSceneNode],),
                'auth': [],
                'endpoint_path': '/reference-organ-scene',
                'operation_id': 'reference_organ_scene',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organ_iri',
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [
                    'organ_iri',
                ],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'organ_iri':
                        (str,),
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'organ_iri': 'organ-iri',
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'organ_iri': 'query',
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reference_organs_endpoint = _Endpoint(
            settings={
                'response_type': ([SpatialEntity],),
                'auth': [],
                'endpoint_path': '/reference-organs',
                'operation_id': 'reference_organs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.scene_endpoint = _Endpoint(
            settings={
                'response_type': ([SpatialSceneNode],),
                'auth': [],
                'endpoint_path': '/scene',
                'operation_id': 'scene',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.technology_names_endpoint = _Endpoint(
            settings={
                'response_type': ([str],),
                'auth': [],
                'endpoint_path': '/technology-names',
                'operation_id': 'technology_names',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cache',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cache':
                        (bool,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'cache': 'cache',
                    'token': 'token',
                },
                'location_map': {
                    'cache': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.tissue_blocks_endpoint = _Endpoint(
            settings={
                'response_type': ([TissueBlock],),
                'auth': [],
                'endpoint_path': '/tissue-blocks',
                'operation_id': 'tissue_blocks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'age',
                    'age_range',
                    'bmi',
                    'bmi_range',
                    'cache',
                    'ontology_terms',
                    'cell_type_terms',
                    'providers',
                    'sex',
                    'technologies',
                    'token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sex',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sex',): {

                        "BOTH": "both",
                        "FEMALE": "female",
                        "MALE": "male"
                    },
                },
                'openapi_types': {
                    'age':
                        (MinMax,),
                    'age_range':
                        (str,),
                    'bmi':
                        (MinMax,),
                    'bmi_range':
                        (str,),
                    'cache':
                        (bool,),
                    'ontology_terms':
                        ([str],),
                    'cell_type_terms':
                        ([str],),
                    'providers':
                        ([str],),
                    'sex':
                        (str,),
                    'technologies':
                        ([str],),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'age': 'age',
                    'age_range': 'age-range',
                    'bmi': 'bmi',
                    'bmi_range': 'bmi-range',
                    'cache': 'cache',
                    'ontology_terms': 'ontology-terms',
                    'cell_type_terms': 'cell-type-terms',
                    'providers': 'providers',
                    'sex': 'sex',
                    'technologies': 'technologies',
                    'token': 'token',
                },
                'location_map': {
                    'age': 'query',
                    'age_range': 'query',
                    'bmi': 'query',
                    'bmi_range': 'query',
                    'cache': 'query',
                    'ontology_terms': 'query',
                    'cell_type_terms': 'query',
                    'providers': 'query',
                    'sex': 'query',
                    'technologies': 'query',
                    'token': 'query',
                },
                'collection_format_map': {
                    'ontology_terms': 'multi',
                    'cell_type_terms': 'multi',
                    'providers': 'multi',
                    'technologies': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def aggregate_results(
        self,
        **kwargs
    ):
        """Get aggregate results / statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.aggregate_results(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [AggregateCount]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.aggregate_results_endpoint.call_with_http_info(**kwargs)

    def cell_type_term_occurences(
        self,
        **kwargs
    ):
        """Get number of cell type term occurrences for a search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cell_type_term_occurences(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            {str: (int,)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.cell_type_term_occurences_endpoint.call_with_http_info(**kwargs)

    def cell_type_tree_model(
        self,
        **kwargs
    ):
        """Get cell type tree nodes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cell_type_tree_model(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OntologyTree
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.cell_type_tree_model_endpoint.call_with_http_info(**kwargs)

    def db_status(
        self,
        **kwargs
    ):
        """Get current status of database  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.db_status(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DatabaseStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.db_status_endpoint.call_with_http_info(**kwargs)

    def gtex_rui_locations(
        self,
        **kwargs
    ):
        """Get all GTEx rui locations (if enabled)  # noqa: E501

        This option is only enabled if GTEX_ROUTES=true in the environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gtex_rui_locations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.gtex_rui_locations_endpoint.call_with_http_info(**kwargs)

    def hubmap_rui_locations(
        self,
        **kwargs
    ):
        """Get all hubmap rui locations (if enabled)  # noqa: E501

        This option is only enabled if HUBMAP_ROUTES=true in the environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.hubmap_rui_locations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.hubmap_rui_locations_endpoint.call_with_http_info(**kwargs)

    def ontology_term_occurences(
        self,
        **kwargs
    ):
        """Get number of ontology term occurrences for a search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ontology_term_occurences(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            {str: (int,)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.ontology_term_occurences_endpoint.call_with_http_info(**kwargs)

    def ontology_tree_model(
        self,
        **kwargs
    ):
        """Get ontology term tree nodes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ontology_tree_model(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OntologyTree
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.ontology_tree_model_endpoint.call_with_http_info(**kwargs)

    def provider_names(
        self,
        **kwargs
    ):
        """Get tissue provider names (for filtering)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.provider_names(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [str]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.provider_names_endpoint.call_with_http_info(**kwargs)

    def reference_organ_scene(
        self,
        organ_iri,
        **kwargs
    ):
        """Get all nodes to form the 3D scene for an organ  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reference_organ_scene(organ_iri, async_req=True)
        >>> result = thread.get()

        Args:
            organ_iri (str): Filter result by organ.

        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [SpatialSceneNode]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organ_iri'] = \
            organ_iri
        return self.reference_organ_scene_endpoint.call_with_http_info(**kwargs)

    def reference_organs(
        self,
        **kwargs
    ):
        """Get all reference organs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reference_organs(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [SpatialEntity]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.reference_organs_endpoint.call_with_http_info(**kwargs)

    def scene(
        self,
        **kwargs
    ):
        """Get all nodes to form the 3D scene of reference body, organs, and tissues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.scene(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [SpatialSceneNode]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.scene_endpoint.call_with_http_info(**kwargs)

    def technology_names(
        self,
        **kwargs
    ):
        """Get technology names (for filtering)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.technology_names(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [str]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.technology_names_endpoint.call_with_http_info(**kwargs)

    def tissue_blocks(
        self,
        **kwargs
    ):
        """Get Tissue Block Results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tissue_blocks(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            age (MinMax): Filter result by age.. [optional]
            age_range (str): Filter result by age.. [optional]
            bmi (MinMax): Filter result by bmi.. [optional]
            bmi_range (str): Filter result by bmi.. [optional]
            cache (bool): Hint to cache (or not) the response of this request. [optional] if omitted the server will use the default value of True
            ontology_terms ([str]): Filter result by ontology terms.. [optional]
            cell_type_terms ([str]): Filter result by ontology terms.. [optional]
            providers ([str]): Filter result by providers.. [optional]
            sex (str): Filter result by sex.. [optional]
            technologies ([str]): Filter result by technologies.. [optional]
            token (str): Authentication token to use for authenticated searches. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [TissueBlock]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.tissue_blocks_endpoint.call_with_http_info(**kwargs)

