"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = exports.PloneVariant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
var PloneVariant;
(function (PloneVariant) {
    PloneVariant["VOLTO"] = "volto";
    PloneVariant["CLASSICUI"] = "classicui";
})(PloneVariant || (exports.PloneVariant = PloneVariant = {}));
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        this.frontendServiceName = undefined;
        this.siteId = options.siteId ?? 'Plone';
        this.variant = options.variant ?? PloneVariant.VOLTO;
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        const backendPort = 8080;
        // Probing
        const backendActionHttpGet = {
            path: '/',
            port: k8s_1.IntOrString.fromNumber(backendPort),
        };
        const backendLivenessProbe = {
            httpGet: backendActionHttpGet,
            initialDelaySeconds: backend.livenessInitialDelaySeconds ?? 30,
            timeoutSeconds: backend.livenessIimeoutSeconds ?? 5,
            periodSeconds: backend.livenessPeriodSeconds ?? 10,
            successThreshold: backend.livenessSuccessThreshold ?? 1,
            failureThreshold: backend.livenessFailureThreshold ?? 3,
        };
        const backendReadinessProbe = {
            httpGet: backendActionHttpGet,
            initialDelaySeconds: backend.readinessInitialDelaySeconds ?? 10,
            timeoutSeconds: backend.readinessIimeoutSeconds ?? 15,
            periodSeconds: backend.readinessPeriodSeconds ?? 10,
            successThreshold: backend.readinessSuccessThreshold ?? 1,
            failureThreshold: backend.readinessFailureThreshold ?? 3,
        };
        // Deployment
        const backendDeployment = new deployment_1.PloneDeployment(this, 'backend', {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? '500m',
            limitMemory: backend.limitMemory ?? '512Mi',
            requestCpu: backend.requestCpu ?? '200m',
            requestMemory: backend.requestMemory ?? '256Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
            livenessProbe: backendLivenessProbe,
            readinessProbe: backendReadinessProbe,
        });
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        if (this.variant == PloneVariant.VOLTO) {
            const frontend = options.frontend ?? {};
            const frontendPort = 3000;
            const frontendLabels = {
                'app.kubernetes.io/name': 'plone-frontend',
                'app.kubernetes.io/component': 'frontend',
                'app.kubernetes.io/version': options.version ?? 'undefined',
            };
            // Probing
            const frontendActionHttpGet = {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            };
            const frontendLivenessProbe = {
                httpGet: frontendActionHttpGet,
                initialDelaySeconds: frontend.livenessInitialDelaySeconds ?? 30,
                timeoutSeconds: frontend.livenessIimeoutSeconds ?? 5,
                periodSeconds: frontend.livenessPeriodSeconds ?? 10,
                successThreshold: frontend.livenessSuccessThreshold ?? 1,
                failureThreshold: frontend.livenessFailureThreshold ?? 3,
            };
            const frontendReadinessProbe = {
                httpGet: frontendActionHttpGet,
                initialDelaySeconds: frontend.readinessInitialDelaySeconds ?? 10,
                timeoutSeconds: frontend.readinessIimeoutSeconds ?? 15,
                periodSeconds: frontend.readinessPeriodSeconds ?? 10,
                successThreshold: frontend.readinessSuccessThreshold ?? 1,
                failureThreshold: frontend.readinessFailureThreshold ?? 3,
            };
            // Environment for RAZZLE
            var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
            if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
                // connect with backend service
                frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:${backendPort}/${this.siteId}`));
            }
            // Deployment
            const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', {
                labels: frontendLabels,
                image: {
                    image: frontend.image ?? 'plone/plone-frontend:latest',
                    imagePullSecrets: options.imagePullSecrets ?? [],
                    imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
                },
                replicas: frontend.replicas,
                limitCpu: frontend.limitCpu ?? '500m',
                limitMemory: frontend.limitMemory ?? '1Gi',
                requestCpu: backend.requestCpu ?? '200m',
                requestMemory: backend.requestMemory ?? '256Mi',
                pdb: {
                    maxUnavailable: frontend.maxUnavailable ?? undefined,
                    minAvailable: frontend.minAvailable ?? undefined,
                },
                port: frontendPort,
                environment: frontendEnvironment,
                livenessProbe: frontendLivenessProbe,
                readinessProbe: frontendReadinessProbe,
            });
            // Service
            const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
                labels: {
                    'app.kubernetes.io/name': 'plone-frontend-service',
                    'app.kubernetes.io/component': 'service',
                },
                targetPort: frontendPort,
                selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
            });
            this.frontendServiceName = frontendService.name;
        }
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGxvbmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGxvbmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpQ0FBOEI7QUFDOUIsdUNBQXVDO0FBQ3ZDLDJDQUF1QztBQUN2Qyw2Q0FBK0M7QUFDL0MsdUNBQW1EO0FBRW5ELHVDQUF5QztBQTZCekMsSUFBWSxZQUdYO0FBSEQsV0FBWSxZQUFZO0lBQ3RCLCtCQUFlLENBQUE7SUFDZix1Q0FBdUIsQ0FBQTtBQUN6QixDQUFDLEVBSFcsWUFBWSw0QkFBWixZQUFZLFFBR3ZCO0FBV0QsTUFBYSxLQUFNLFNBQVEsc0JBQVM7SUFlbEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxVQUF3QixFQUFFO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztRQUNyQyxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLElBQUksT0FBTyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sSUFBSSxZQUFZLENBQUMsS0FBSyxDQUFDO1FBRXJELDJFQUEyRTtRQUMzRSxVQUFVO1FBQ1YsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sSUFBSSxFQUFFLENBQUM7UUFDdEMsTUFBTSxhQUFhLEdBQUc7WUFDcEIsd0JBQXdCLEVBQUUsZUFBZTtZQUN6Qyw2QkFBNkIsRUFBRSxTQUFTO1lBQ3hDLDJCQUEyQixFQUFFLE9BQU8sQ0FBQyxPQUFPLElBQUksV0FBVztTQUM1RCxDQUFDO1FBQ0YsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDO1FBRXpCLFVBQVU7UUFDVixNQUFNLG9CQUFvQixHQUFzQjtZQUM5QyxJQUFJLEVBQUUsR0FBRztZQUNULElBQUksRUFBRSxpQkFBVyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7U0FDMUMsQ0FBQztRQUVGLE1BQU0sb0JBQW9CLEdBQVU7WUFDbEMsT0FBTyxFQUFFLG9CQUFvQjtZQUM3QixtQkFBbUIsRUFBRSxPQUFPLENBQUMsMkJBQTJCLElBQUksRUFBRTtZQUM5RCxjQUFjLEVBQUUsT0FBTyxDQUFDLHNCQUFzQixJQUFJLENBQUM7WUFDbkQsYUFBYSxFQUFFLE9BQU8sQ0FBQyxxQkFBcUIsSUFBSSxFQUFFO1lBQ2xELGdCQUFnQixFQUFFLE9BQU8sQ0FBQyx3QkFBd0IsSUFBSSxDQUFDO1lBQ3ZELGdCQUFnQixFQUFFLE9BQU8sQ0FBQyx3QkFBd0IsSUFBSSxDQUFDO1NBQ3hELENBQUM7UUFDRixNQUFNLHFCQUFxQixHQUFVO1lBQ25DLE9BQU8sRUFBRSxvQkFBb0I7WUFDN0IsbUJBQW1CLEVBQUUsT0FBTyxDQUFDLDRCQUE0QixJQUFJLEVBQUU7WUFDL0QsY0FBYyxFQUFFLE9BQU8sQ0FBQyx1QkFBdUIsSUFBSSxFQUFFO1lBQ3JELGFBQWEsRUFBRSxPQUFPLENBQUMsc0JBQXNCLElBQUksRUFBRTtZQUNuRCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMseUJBQXlCLElBQUksQ0FBQztZQUN4RCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMseUJBQXlCLElBQUksQ0FBQztTQUN6RCxDQUFDO1FBRUYsYUFBYTtRQUNiLE1BQU0saUJBQWlCLEdBQUcsSUFBSSw0QkFBZSxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDN0QsTUFBTSxFQUFFLGFBQWE7WUFDckIsS0FBSyxFQUFFO2dCQUNMLEtBQUssRUFBRSxPQUFPLENBQUMsS0FBSyxJQUFJLDRCQUE0QjtnQkFDcEQsZ0JBQWdCLEVBQUUsT0FBTyxDQUFDLGdCQUFnQixJQUFJLEVBQUU7Z0JBQ2hELGVBQWUsRUFBRSxPQUFPLENBQUMsZUFBZSxJQUFJLGNBQWM7YUFDM0Q7WUFDRCxRQUFRLEVBQUUsT0FBTyxDQUFDLFFBQVE7WUFDMUIsUUFBUSxFQUFFLE9BQU8sQ0FBQyxRQUFRLElBQUksTUFBTTtZQUNwQyxXQUFXLEVBQUUsT0FBTyxDQUFDLFdBQVcsSUFBSSxPQUFPO1lBQzNDLFVBQVUsRUFBRSxPQUFPLENBQUMsVUFBVSxJQUFJLE1BQU07WUFDeEMsYUFBYSxFQUFFLE9BQU8sQ0FBQyxhQUFhLElBQUksT0FBTztZQUMvQyxHQUFHLEVBQUU7Z0JBQ0gsY0FBYyxFQUFFLE9BQU8sQ0FBQyxjQUFjLElBQUksU0FBUztnQkFDbkQsWUFBWSxFQUFFLE9BQU8sQ0FBQyxZQUFZLElBQUksU0FBUzthQUNoRDtZQUNELElBQUksRUFBRSxXQUFXO1lBQ2pCLFdBQVcsRUFBRSxPQUFPLENBQUMsV0FBVztZQUNoQyxhQUFhLEVBQUUsb0JBQW9CO1lBQ25DLGNBQWMsRUFBRSxxQkFBcUI7U0FDdEMsQ0FBQyxDQUFDO1FBRUgsVUFBVTtRQUNWLE1BQU0sY0FBYyxHQUFHLElBQUksc0JBQVksQ0FBQyxpQkFBaUIsRUFBRSxTQUFTLEVBQUU7WUFDcEUsTUFBTSxFQUFFO2dCQUNOLHdCQUF3QixFQUFFLHVCQUF1QjtnQkFDakQsNkJBQTZCLEVBQUUsU0FBUzthQUN6QztZQUNELFVBQVUsRUFBRSxXQUFXO1lBQ3ZCLGFBQWEsRUFBRSxFQUFFLEdBQUcsRUFBRSxhQUFLLENBQUMsWUFBWSxDQUFDLGlCQUFpQixDQUFDLEVBQUU7U0FDOUQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGtCQUFrQixHQUFHLGNBQWMsQ0FBQyxJQUFJLENBQUM7UUFFOUMsMkVBQTJFO1FBQzNFLFdBQVc7UUFDWCxJQUFJLElBQUksQ0FBQyxPQUFPLElBQUksWUFBWSxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ3ZDLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLElBQUksRUFBRSxDQUFDO1lBQ3hDLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQztZQUMxQixNQUFNLGNBQWMsR0FBRztnQkFDckIsd0JBQXdCLEVBQUUsZ0JBQWdCO2dCQUMxQyw2QkFBNkIsRUFBRSxVQUFVO2dCQUN6QywyQkFBMkIsRUFBRSxPQUFPLENBQUMsT0FBTyxJQUFJLFdBQVc7YUFDNUQsQ0FBQztZQUVGLFVBQVU7WUFDVixNQUFNLHFCQUFxQixHQUFzQjtnQkFDL0MsSUFBSSxFQUFFLEdBQUc7Z0JBQ1QsSUFBSSxFQUFFLGlCQUFXLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQzthQUMzQyxDQUFDO1lBQ0YsTUFBTSxxQkFBcUIsR0FBVTtnQkFDbkMsT0FBTyxFQUFFLHFCQUFxQjtnQkFDOUIsbUJBQW1CLEVBQUUsUUFBUSxDQUFDLDJCQUEyQixJQUFJLEVBQUU7Z0JBQy9ELGNBQWMsRUFBRSxRQUFRLENBQUMsc0JBQXNCLElBQUksQ0FBQztnQkFDcEQsYUFBYSxFQUFFLFFBQVEsQ0FBQyxxQkFBcUIsSUFBSSxFQUFFO2dCQUNuRCxnQkFBZ0IsRUFBRSxRQUFRLENBQUMsd0JBQXdCLElBQUksQ0FBQztnQkFDeEQsZ0JBQWdCLEVBQUUsUUFBUSxDQUFDLHdCQUF3QixJQUFJLENBQUM7YUFDekQsQ0FBQztZQUNGLE1BQU0sc0JBQXNCLEdBQVU7Z0JBQ3BDLE9BQU8sRUFBRSxxQkFBcUI7Z0JBQzlCLG1CQUFtQixFQUFFLFFBQVEsQ0FBQyw0QkFBNEIsSUFBSSxFQUFFO2dCQUNoRSxjQUFjLEVBQUUsUUFBUSxDQUFDLHVCQUF1QixJQUFJLEVBQUU7Z0JBQ3RELGFBQWEsRUFBRSxRQUFRLENBQUMsc0JBQXNCLElBQUksRUFBRTtnQkFDcEQsZ0JBQWdCLEVBQUUsUUFBUSxDQUFDLHlCQUF5QixJQUFJLENBQUM7Z0JBQ3pELGdCQUFnQixFQUFFLFFBQVEsQ0FBQyx5QkFBeUIsSUFBSSxDQUFDO2FBQzFELENBQUM7WUFFRix5QkFBeUI7WUFDekIsSUFBSSxtQkFBbUIsR0FBRyxRQUFRLENBQUMsV0FBVyxJQUFJLElBQUksS0FBSyxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDeEUsSUFBSSxtQkFBbUIsQ0FBQyxTQUFTLENBQUMsd0JBQXdCLEtBQUssU0FBUyxFQUFFLENBQUM7Z0JBQ3pFLCtCQUErQjtnQkFDL0IsbUJBQW1CLEVBQUUsV0FBVyxDQUFDLDBCQUEwQixFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLFVBQVUsY0FBYyxDQUFDLElBQUksSUFBSSxXQUFXLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUMsQ0FBQztZQUN4SixDQUFDO1lBRUQsYUFBYTtZQUNiLE1BQU0sa0JBQWtCLEdBQUcsSUFBSSw0QkFBZSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7Z0JBQy9ELE1BQU0sRUFBRSxjQUFjO2dCQUN0QixLQUFLLEVBQUU7b0JBQ0wsS0FBSyxFQUFFLFFBQVEsQ0FBQyxLQUFLLElBQUksNkJBQTZCO29CQUN0RCxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLElBQUksRUFBRTtvQkFDaEQsZUFBZSxFQUFFLFFBQVEsQ0FBQyxlQUFlLElBQUksY0FBYztpQkFDNUQ7Z0JBQ0QsUUFBUSxFQUFFLFFBQVEsQ0FBQyxRQUFRO2dCQUMzQixRQUFRLEVBQUUsUUFBUSxDQUFDLFFBQVEsSUFBSSxNQUFNO2dCQUNyQyxXQUFXLEVBQUUsUUFBUSxDQUFDLFdBQVcsSUFBSSxLQUFLO2dCQUMxQyxVQUFVLEVBQUUsT0FBTyxDQUFDLFVBQVUsSUFBSSxNQUFNO2dCQUN4QyxhQUFhLEVBQUUsT0FBTyxDQUFDLGFBQWEsSUFBSSxPQUFPO2dCQUUvQyxHQUFHLEVBQUU7b0JBQ0gsY0FBYyxFQUFFLFFBQVEsQ0FBQyxjQUFjLElBQUksU0FBUztvQkFDcEQsWUFBWSxFQUFFLFFBQVEsQ0FBQyxZQUFZLElBQUksU0FBUztpQkFDakQ7Z0JBQ0QsSUFBSSxFQUFFLFlBQVk7Z0JBQ2xCLFdBQVcsRUFBRSxtQkFBbUI7Z0JBQ2hDLGFBQWEsRUFBRSxxQkFBcUI7Z0JBQ3BDLGNBQWMsRUFBRSxzQkFBc0I7YUFDdkMsQ0FBQyxDQUFDO1lBRUgsVUFBVTtZQUNWLE1BQU0sZUFBZSxHQUFHLElBQUksc0JBQVksQ0FBQyxrQkFBa0IsRUFBRSxTQUFTLEVBQUU7Z0JBQ3RFLE1BQU0sRUFBRTtvQkFDTix3QkFBd0IsRUFBRSx3QkFBd0I7b0JBQ2xELDZCQUE2QixFQUFFLFNBQVM7aUJBQ3pDO2dCQUNELFVBQVUsRUFBRSxZQUFZO2dCQUN4QixhQUFhLEVBQUUsRUFBRSxHQUFHLEVBQUUsYUFBSyxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxFQUFFO2FBQy9ELENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxtQkFBbUIsR0FBRyxlQUFlLENBQUMsSUFBSSxDQUFDO1FBQ2xELENBQUM7SUFDSCxDQUFDOztBQW5LSCxzQkFvS0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBOYW1lcyB9IGZyb20gJ2NkazhzJztcbmltcG9ydCAqIGFzIGtwbHVzIGZyb20gJ2NkazhzLXBsdXMtMjQnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBQbG9uZURlcGxveW1lbnQgfSBmcm9tICcuL2RlcGxveW1lbnQnO1xuaW1wb3J0IHsgUHJvYmUsIEludE9yU3RyaW5nIH0gZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5pbXBvcnQgKiBhcyBrOHMgZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5pbXBvcnQgeyBQbG9uZVNlcnZpY2UgfSBmcm9tICcuL3NlcnZpY2UnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFBsb25lQmFzZU9wdGlvbnMge1xuICAvLyBpbWFnZVxuICByZWFkb25seSBpbWFnZT86IHN0cmluZztcbiAgcmVhZG9ubHkgaW1hZ2VQdWxsUG9saWN5Pzogc3RyaW5nO1xuICAvLyByZXBsaWNhc1xuICByZWFkb25seSByZXBsaWNhcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgbWF4VW5hdmFpbGFibGU/OiBudW1iZXIgfCBzdHJpbmc7XG4gIHJlYWRvbmx5IG1pbkF2YWlsYWJsZT86IG51bWJlciB8IHN0cmluZztcbiAgLy8gcmVzb3VyY2VzXG4gIHJlYWRvbmx5IGxpbWl0Q3B1Pzogc3RyaW5nO1xuICByZWFkb25seSBsaW1pdE1lbW9yeT86IHN0cmluZztcbiAgcmVhZG9ubHkgcmVxdWVzdENwdT86IHN0cmluZztcbiAgcmVhZG9ubHkgcmVxdWVzdE1lbW9yeT86IHN0cmluZztcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnQ/OiBrcGx1cy5FbnY7XG4gIC8vIHJlYWRpbmVzcyBQcm9iZVxuICByZWFkb25seSByZWFkaW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSByZWFkaW5lc3NJaW1lb3V0U2Vjb25kcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzUGVyaW9kU2Vjb25kcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzU3VjY2Vzc1RocmVzaG9sZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgcmVhZGluZXNzRmFpbHVyZVRocmVzaG9sZD86IG51bWJlcjtcbiAgLy8gbGl2ZW5lc3MgUHJvYmVcbiAgcmVhZG9ubHkgbGl2ZW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSBsaXZlbmVzc0lpbWVvdXRTZWNvbmRzPzogbnVtYmVyO1xuICByZWFkb25seSBsaXZlbmVzc1BlcmlvZFNlY29uZHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGxpdmVuZXNzU3VjY2Vzc1RocmVzaG9sZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgbGl2ZW5lc3NGYWlsdXJlVGhyZXNob2xkPzogbnVtYmVyO1xufVxuZXhwb3J0IGVudW0gUGxvbmVWYXJpYW50IHtcbiAgVk9MVE8gPSAndm9sdG8nLFxuICBDTEFTU0lDVUkgPSAnY2xhc3NpY3VpJyxcbn1cbmV4cG9ydCBpbnRlcmZhY2UgUGxvbmVPcHRpb25zIHtcbiAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgc2l0ZUlkPzogc3RyaW5nO1xuICByZWFkb25seSB2YXJpYW50PzogUGxvbmVWYXJpYW50O1xuICByZWFkb25seSBiYWNrZW5kPzogUGxvbmVCYXNlT3B0aW9ucztcbiAgcmVhZG9ubHkgZnJvbnRlbmQ/OiBQbG9uZUJhc2VPcHRpb25zO1xuICByZWFkb25seSBpbWFnZVB1bGxTZWNyZXRzPzogc3RyaW5nW107XG5cbn1cblxuZXhwb3J0IGNsYXNzIFBsb25lIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgLyogQ3JlYXRlIGFsbCBlbGVtZW50cyBmb3IgYSBQbG9uZSBkZXBsb3ltZW50IGluIEt1YmVybmV0ZXNcbiAgICAqIHRoZXJlIGFyZSB0d28gdmFyaWFudHMgb2YgUGxvbmUgZGVwbG95bWVudDpcbiAgICAgIC0gXCJ2b2x0b1wiOiBmcm9udGVuZCBhbmQgYmFja2VuZCBhbmQgZnJvbnRlbmQsIGRlZmF1bHQgKHJlYWN0anMgcmVuZGVyZWQgSFRNTClcbiAgICAgIC0gXCJjbGFzc2ljdWk6IGJhY2tlbmQgb25seSAoU1NSIEhUTUwpXG5cbiAgICAqIEBwYXJhbSBzY29wZSAtIENvbnN0cnVjdCBzY29wZVxuICAgICogQHBhcmFtIGlkIC0gQ29uc3RydWN0IGlkXG4gICAgKiBAcGFyYW0gb3B0aW9ucyAtIFBsb25lT3B0aW9uc1xuICAgICovXG4gIHB1YmxpYyByZWFkb25seSBiYWNrZW5kU2VydmljZU5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGZyb250ZW5kU2VydmljZU5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcbiAgcHVibGljIHJlYWRvbmx5IHZhcmlhbnQ6IFBsb25lVmFyaWFudDtcbiAgcHVibGljIHJlYWRvbmx5IHNpdGVJZDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIG9wdGlvbnM6IFBsb25lT3B0aW9ucyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLmZyb250ZW5kU2VydmljZU5hbWUgPSB1bmRlZmluZWQ7XG4gICAgdGhpcy5zaXRlSWQgPSBvcHRpb25zLnNpdGVJZCA/PyAnUGxvbmUnO1xuICAgIHRoaXMudmFyaWFudCA9IG9wdGlvbnMudmFyaWFudCA/PyBQbG9uZVZhcmlhbnQuVk9MVE87XG5cbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiAgICAvLyBCYWNrZW5kXG4gICAgY29uc3QgYmFja2VuZCA9IG9wdGlvbnMuYmFja2VuZCA/PyB7fTtcbiAgICBjb25zdCBiYWNrZW5kTGFiZWxzID0ge1xuICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL25hbWUnOiAncGxvbmUtYmFja2VuZCcsXG4gICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ2JhY2tlbmQnLFxuICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL3ZlcnNpb24nOiBvcHRpb25zLnZlcnNpb24gPz8gJ3VuZGVmaW5lZCcsXG4gICAgfTtcbiAgICBjb25zdCBiYWNrZW5kUG9ydCA9IDgwODA7XG5cbiAgICAvLyBQcm9iaW5nXG4gICAgY29uc3QgYmFja2VuZEFjdGlvbkh0dHBHZXQ6IGs4cy5IdHRwR2V0QWN0aW9uID0ge1xuICAgICAgcGF0aDogJy8nLFxuICAgICAgcG9ydDogSW50T3JTdHJpbmcuZnJvbU51bWJlcihiYWNrZW5kUG9ydCksXG4gICAgfTtcblxuICAgIGNvbnN0IGJhY2tlbmRMaXZlbmVzc1Byb2JlOiBQcm9iZSA9IHtcbiAgICAgIGh0dHBHZXQ6IGJhY2tlbmRBY3Rpb25IdHRwR2V0LFxuICAgICAgaW5pdGlhbERlbGF5U2Vjb25kczogYmFja2VuZC5saXZlbmVzc0luaXRpYWxEZWxheVNlY29uZHMgPz8gMzAsXG4gICAgICB0aW1lb3V0U2Vjb25kczogYmFja2VuZC5saXZlbmVzc0lpbWVvdXRTZWNvbmRzID8/IDUsXG4gICAgICBwZXJpb2RTZWNvbmRzOiBiYWNrZW5kLmxpdmVuZXNzUGVyaW9kU2Vjb25kcyA/PyAxMCxcbiAgICAgIHN1Y2Nlc3NUaHJlc2hvbGQ6IGJhY2tlbmQubGl2ZW5lc3NTdWNjZXNzVGhyZXNob2xkID8/IDEsXG4gICAgICBmYWlsdXJlVGhyZXNob2xkOiBiYWNrZW5kLmxpdmVuZXNzRmFpbHVyZVRocmVzaG9sZCA/PyAzLFxuICAgIH07XG4gICAgY29uc3QgYmFja2VuZFJlYWRpbmVzc1Byb2JlOiBQcm9iZSA9IHtcbiAgICAgIGh0dHBHZXQ6IGJhY2tlbmRBY3Rpb25IdHRwR2V0LFxuICAgICAgaW5pdGlhbERlbGF5U2Vjb25kczogYmFja2VuZC5yZWFkaW5lc3NJbml0aWFsRGVsYXlTZWNvbmRzID8/IDEwLFxuICAgICAgdGltZW91dFNlY29uZHM6IGJhY2tlbmQucmVhZGluZXNzSWltZW91dFNlY29uZHMgPz8gMTUsXG4gICAgICBwZXJpb2RTZWNvbmRzOiBiYWNrZW5kLnJlYWRpbmVzc1BlcmlvZFNlY29uZHMgPz8gMTAsXG4gICAgICBzdWNjZXNzVGhyZXNob2xkOiBiYWNrZW5kLnJlYWRpbmVzc1N1Y2Nlc3NUaHJlc2hvbGQgPz8gMSxcbiAgICAgIGZhaWx1cmVUaHJlc2hvbGQ6IGJhY2tlbmQucmVhZGluZXNzRmFpbHVyZVRocmVzaG9sZCA/PyAzLFxuICAgIH07XG5cbiAgICAvLyBEZXBsb3ltZW50XG4gICAgY29uc3QgYmFja2VuZERlcGxveW1lbnQgPSBuZXcgUGxvbmVEZXBsb3ltZW50KHRoaXMsICdiYWNrZW5kJywge1xuICAgICAgbGFiZWxzOiBiYWNrZW5kTGFiZWxzLFxuICAgICAgaW1hZ2U6IHtcbiAgICAgICAgaW1hZ2U6IGJhY2tlbmQuaW1hZ2UgPz8gJ3Bsb25lL3Bsb25lLWJhY2tlbmQ6bGF0ZXN0JyxcbiAgICAgICAgaW1hZ2VQdWxsU2VjcmV0czogb3B0aW9ucy5pbWFnZVB1bGxTZWNyZXRzID8/IFtdLFxuICAgICAgICBpbWFnZVB1bGxQb2xpY3k6IGJhY2tlbmQuaW1hZ2VQdWxsUG9saWN5ID8/ICdJZk5vdFByZXNlbnQnLFxuICAgICAgfSxcbiAgICAgIHJlcGxpY2FzOiBiYWNrZW5kLnJlcGxpY2FzLFxuICAgICAgbGltaXRDcHU6IGJhY2tlbmQubGltaXRDcHUgPz8gJzUwMG0nLFxuICAgICAgbGltaXRNZW1vcnk6IGJhY2tlbmQubGltaXRNZW1vcnkgPz8gJzUxMk1pJyxcbiAgICAgIHJlcXVlc3RDcHU6IGJhY2tlbmQucmVxdWVzdENwdSA/PyAnMjAwbScsXG4gICAgICByZXF1ZXN0TWVtb3J5OiBiYWNrZW5kLnJlcXVlc3RNZW1vcnkgPz8gJzI1Nk1pJyxcbiAgICAgIHBkYjoge1xuICAgICAgICBtYXhVbmF2YWlsYWJsZTogYmFja2VuZC5tYXhVbmF2YWlsYWJsZSA/PyB1bmRlZmluZWQsXG4gICAgICAgIG1pbkF2YWlsYWJsZTogYmFja2VuZC5taW5BdmFpbGFibGUgPz8gdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICAgIHBvcnQ6IGJhY2tlbmRQb3J0LFxuICAgICAgZW52aXJvbm1lbnQ6IGJhY2tlbmQuZW52aXJvbm1lbnQsXG4gICAgICBsaXZlbmVzc1Byb2JlOiBiYWNrZW5kTGl2ZW5lc3NQcm9iZSxcbiAgICAgIHJlYWRpbmVzc1Byb2JlOiBiYWNrZW5kUmVhZGluZXNzUHJvYmUsXG4gICAgfSk7XG5cbiAgICAvLyBTZXJ2aWNlXG4gICAgY29uc3QgYmFja2VuZFNlcnZpY2UgPSBuZXcgUGxvbmVTZXJ2aWNlKGJhY2tlbmREZXBsb3ltZW50LCAnc2VydmljZScsIHtcbiAgICAgIGxhYmVsczoge1xuICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6ICdwbG9uZS1iYWNrZW5kLXNlcnZpY2UnLFxuICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ3NlcnZpY2UnLFxuICAgICAgfSxcbiAgICAgIHRhcmdldFBvcnQ6IGJhY2tlbmRQb3J0LFxuICAgICAgc2VsZWN0b3JMYWJlbDogeyBhcHA6IE5hbWVzLnRvTGFiZWxWYWx1ZShiYWNrZW5kRGVwbG95bWVudCkgfSxcbiAgICB9KTtcbiAgICB0aGlzLmJhY2tlbmRTZXJ2aWNlTmFtZSA9IGJhY2tlbmRTZXJ2aWNlLm5hbWU7XG5cbiAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiAgICAvLyBGcm9udGVuZFxuICAgIGlmICh0aGlzLnZhcmlhbnQgPT0gUGxvbmVWYXJpYW50LlZPTFRPKSB7XG4gICAgICBjb25zdCBmcm9udGVuZCA9IG9wdGlvbnMuZnJvbnRlbmQgPz8ge307XG4gICAgICBjb25zdCBmcm9udGVuZFBvcnQgPSAzMDAwO1xuICAgICAgY29uc3QgZnJvbnRlbmRMYWJlbHMgPSB7XG4gICAgICAgICdhcHAua3ViZXJuZXRlcy5pby9uYW1lJzogJ3Bsb25lLWZyb250ZW5kJyxcbiAgICAgICAgJ2FwcC5rdWJlcm5ldGVzLmlvL2NvbXBvbmVudCc6ICdmcm9udGVuZCcsXG4gICAgICAgICdhcHAua3ViZXJuZXRlcy5pby92ZXJzaW9uJzogb3B0aW9ucy52ZXJzaW9uID8/ICd1bmRlZmluZWQnLFxuICAgICAgfTtcblxuICAgICAgLy8gUHJvYmluZ1xuICAgICAgY29uc3QgZnJvbnRlbmRBY3Rpb25IdHRwR2V0OiBrOHMuSHR0cEdldEFjdGlvbiA9IHtcbiAgICAgICAgcGF0aDogJy8nLFxuICAgICAgICBwb3J0OiBJbnRPclN0cmluZy5mcm9tTnVtYmVyKGZyb250ZW5kUG9ydCksXG4gICAgICB9O1xuICAgICAgY29uc3QgZnJvbnRlbmRMaXZlbmVzc1Byb2JlOiBQcm9iZSA9IHtcbiAgICAgICAgaHR0cEdldDogZnJvbnRlbmRBY3Rpb25IdHRwR2V0LFxuICAgICAgICBpbml0aWFsRGVsYXlTZWNvbmRzOiBmcm9udGVuZC5saXZlbmVzc0luaXRpYWxEZWxheVNlY29uZHMgPz8gMzAsXG4gICAgICAgIHRpbWVvdXRTZWNvbmRzOiBmcm9udGVuZC5saXZlbmVzc0lpbWVvdXRTZWNvbmRzID8/IDUsXG4gICAgICAgIHBlcmlvZFNlY29uZHM6IGZyb250ZW5kLmxpdmVuZXNzUGVyaW9kU2Vjb25kcyA/PyAxMCxcbiAgICAgICAgc3VjY2Vzc1RocmVzaG9sZDogZnJvbnRlbmQubGl2ZW5lc3NTdWNjZXNzVGhyZXNob2xkID8/IDEsXG4gICAgICAgIGZhaWx1cmVUaHJlc2hvbGQ6IGZyb250ZW5kLmxpdmVuZXNzRmFpbHVyZVRocmVzaG9sZCA/PyAzLFxuICAgICAgfTtcbiAgICAgIGNvbnN0IGZyb250ZW5kUmVhZGluZXNzUHJvYmU6IFByb2JlID0ge1xuICAgICAgICBodHRwR2V0OiBmcm9udGVuZEFjdGlvbkh0dHBHZXQsXG4gICAgICAgIGluaXRpYWxEZWxheVNlY29uZHM6IGZyb250ZW5kLnJlYWRpbmVzc0luaXRpYWxEZWxheVNlY29uZHMgPz8gMTAsXG4gICAgICAgIHRpbWVvdXRTZWNvbmRzOiBmcm9udGVuZC5yZWFkaW5lc3NJaW1lb3V0U2Vjb25kcyA/PyAxNSxcbiAgICAgICAgcGVyaW9kU2Vjb25kczogZnJvbnRlbmQucmVhZGluZXNzUGVyaW9kU2Vjb25kcyA/PyAxMCxcbiAgICAgICAgc3VjY2Vzc1RocmVzaG9sZDogZnJvbnRlbmQucmVhZGluZXNzU3VjY2Vzc1RocmVzaG9sZCA/PyAxLFxuICAgICAgICBmYWlsdXJlVGhyZXNob2xkOiBmcm9udGVuZC5yZWFkaW5lc3NGYWlsdXJlVGhyZXNob2xkID8/IDMsXG4gICAgICB9O1xuXG4gICAgICAvLyBFbnZpcm9ubWVudCBmb3IgUkFaWkxFXG4gICAgICB2YXIgZnJvbnRlbmRFbnZpcm9ubWVudCA9IGZyb250ZW5kLmVudmlyb25tZW50ID8/IG5ldyBrcGx1cy5FbnYoW10sIHt9KTtcbiAgICAgIGlmIChmcm9udGVuZEVudmlyb25tZW50LnZhcmlhYmxlcy5SQVpaTEVfSU5URVJOQUxfQVBJX1BBVEggPT09IHVuZGVmaW5lZCkge1xuICAgICAgICAvLyBjb25uZWN0IHdpdGggYmFja2VuZCBzZXJ2aWNlXG4gICAgICAgIGZyb250ZW5kRW52aXJvbm1lbnQ/LmFkZFZhcmlhYmxlKCdSQVpaTEVfSU5URVJOQUxfQVBJX1BBVEgnLCBrcGx1cy5FbnZWYWx1ZS5mcm9tVmFsdWUoYGh0dHA6Ly8ke2JhY2tlbmRTZXJ2aWNlLm5hbWV9OiR7YmFja2VuZFBvcnR9LyR7dGhpcy5zaXRlSWR9YCkpO1xuICAgICAgfVxuXG4gICAgICAvLyBEZXBsb3ltZW50XG4gICAgICBjb25zdCBmcm9udGVuZERlcGxveW1lbnQgPSBuZXcgUGxvbmVEZXBsb3ltZW50KHRoaXMsICdmcm9udGVuZCcsIHtcbiAgICAgICAgbGFiZWxzOiBmcm9udGVuZExhYmVscyxcbiAgICAgICAgaW1hZ2U6IHtcbiAgICAgICAgICBpbWFnZTogZnJvbnRlbmQuaW1hZ2UgPz8gJ3Bsb25lL3Bsb25lLWZyb250ZW5kOmxhdGVzdCcsXG4gICAgICAgICAgaW1hZ2VQdWxsU2VjcmV0czogb3B0aW9ucy5pbWFnZVB1bGxTZWNyZXRzID8/IFtdLFxuICAgICAgICAgIGltYWdlUHVsbFBvbGljeTogZnJvbnRlbmQuaW1hZ2VQdWxsUG9saWN5ID8/ICdJZk5vdFByZXNlbnQnLFxuICAgICAgICB9LFxuICAgICAgICByZXBsaWNhczogZnJvbnRlbmQucmVwbGljYXMsXG4gICAgICAgIGxpbWl0Q3B1OiBmcm9udGVuZC5saW1pdENwdSA/PyAnNTAwbScsXG4gICAgICAgIGxpbWl0TWVtb3J5OiBmcm9udGVuZC5saW1pdE1lbW9yeSA/PyAnMUdpJyxcbiAgICAgICAgcmVxdWVzdENwdTogYmFja2VuZC5yZXF1ZXN0Q3B1ID8/ICcyMDBtJyxcbiAgICAgICAgcmVxdWVzdE1lbW9yeTogYmFja2VuZC5yZXF1ZXN0TWVtb3J5ID8/ICcyNTZNaScsXG5cbiAgICAgICAgcGRiOiB7XG4gICAgICAgICAgbWF4VW5hdmFpbGFibGU6IGZyb250ZW5kLm1heFVuYXZhaWxhYmxlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgICBtaW5BdmFpbGFibGU6IGZyb250ZW5kLm1pbkF2YWlsYWJsZSA/PyB1bmRlZmluZWQsXG4gICAgICAgIH0sXG4gICAgICAgIHBvcnQ6IGZyb250ZW5kUG9ydCxcbiAgICAgICAgZW52aXJvbm1lbnQ6IGZyb250ZW5kRW52aXJvbm1lbnQsXG4gICAgICAgIGxpdmVuZXNzUHJvYmU6IGZyb250ZW5kTGl2ZW5lc3NQcm9iZSxcbiAgICAgICAgcmVhZGluZXNzUHJvYmU6IGZyb250ZW5kUmVhZGluZXNzUHJvYmUsXG4gICAgICB9KTtcblxuICAgICAgLy8gU2VydmljZVxuICAgICAgY29uc3QgZnJvbnRlbmRTZXJ2aWNlID0gbmV3IFBsb25lU2VydmljZShmcm9udGVuZERlcGxveW1lbnQsICdzZXJ2aWNlJywge1xuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vbmFtZSc6ICdwbG9uZS1mcm9udGVuZC1zZXJ2aWNlJyxcbiAgICAgICAgICAnYXBwLmt1YmVybmV0ZXMuaW8vY29tcG9uZW50JzogJ3NlcnZpY2UnLFxuICAgICAgICB9LFxuICAgICAgICB0YXJnZXRQb3J0OiBmcm9udGVuZFBvcnQsXG4gICAgICAgIHNlbGVjdG9yTGFiZWw6IHsgYXBwOiBOYW1lcy50b0xhYmVsVmFsdWUoZnJvbnRlbmREZXBsb3ltZW50KSB9LFxuICAgICAgfSk7XG4gICAgICB0aGlzLmZyb250ZW5kU2VydmljZU5hbWUgPSBmcm9udGVuZFNlcnZpY2UubmFtZTtcbiAgICB9XG4gIH1cbn0iXX0=