import * as kplus from 'cdk8s-plus-24';
import { Construct } from 'constructs';
export interface PloneBaseOptions {
    readonly image?: string;
    readonly imagePullPolicy?: string;
    readonly replicas?: number;
    readonly maxUnavailable?: number | string;
    readonly minAvailable?: number | string;
    readonly limitCpu?: string;
    readonly limitMemory?: string;
    readonly requestCpu?: string;
    readonly requestMemory?: string;
    readonly environment?: kplus.Env;
    readonly readinessInitialDelaySeconds?: number;
    readonly readinessIimeoutSeconds?: number;
    readonly readinessPeriodSeconds?: number;
    readonly readinessSuccessThreshold?: number;
    readonly readinessFailureThreshold?: number;
    readonly livenessInitialDelaySeconds?: number;
    readonly livenessIimeoutSeconds?: number;
    readonly livenessPeriodSeconds?: number;
    readonly livenessSuccessThreshold?: number;
    readonly livenessFailureThreshold?: number;
}
export declare enum PloneVariant {
    VOLTO = "volto",
    CLASSICUI = "classicui"
}
export interface PloneOptions {
    readonly version?: string;
    readonly siteId?: string;
    readonly variant?: PloneVariant;
    readonly backend?: PloneBaseOptions;
    readonly frontend?: PloneBaseOptions;
    readonly imagePullSecrets?: string[];
}
export declare class Plone extends Construct {
    readonly backendServiceName: string;
    readonly frontendServiceName: string | undefined;
    readonly variant: PloneVariant;
    readonly siteId: string;
    constructor(scope: Construct, id: string, options?: PloneOptions);
}
