"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretRotation = exports.SecretRotationApplication = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const lambda = require("@aws-cdk/aws-lambda");
const serverless = require("@aws-cdk/aws-sam");
const core_1 = require("@aws-cdk/core");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * A secret rotation serverless application.
 */
class SecretRotationApplication {
    constructor(applicationId, semanticVersion, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SecretRotationApplicationOptions(options);
        this.applicationId = `arn:aws:serverlessrepo:us-east-1:297356227824:applications/${applicationId}`;
        this.semanticVersion = semanticVersion;
        this.applicationName = applicationId;
        this.isMultiUser = options && options.isMultiUser;
    }
    /**
     * Returns the application ARN for the current partition.
     * Can be used in combination with a `CfnMapping` to automatically select the correct ARN based on the current partition.
     */
    applicationArnForPartition(partition) {
        if (partition === 'aws') {
            return this.applicationId;
        }
        else if (partition === 'aws-cn') {
            return `arn:aws-cn:serverlessrepo:cn-north-1:193023089310:applications/${this.applicationName}`;
        }
        else if (partition === 'aws-us-gov') {
            return `arn:aws-us-gov:serverlessrepo:us-gov-west-1:023102451235:applications/${this.applicationName}`;
        }
        else {
            throw new Error(`unsupported partition: ${partition}`);
        }
    }
    /**
     * The semantic version of the app for the current partition.
     * Can be used in combination with a `CfnMapping` to automatically select the correct version based on the current partition.
     */
    semanticVersionForPartition(partition) {
        if (partition === 'aws') {
            return this.semanticVersion;
        }
        else if (partition === 'aws-cn') {
            return '1.1.37';
        }
        else if (partition === 'aws-us-gov') {
            return '1.1.93';
        }
        else {
            throw new Error(`unsupported partition: ${partition}`);
        }
    }
}
exports.SecretRotationApplication = SecretRotationApplication;
_a = JSII_RTTI_SYMBOL_1;
SecretRotationApplication[_a] = { fqn: "@aws-cdk/aws-secretsmanager.SecretRotationApplication", version: "1.151.0" };
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme
 */
SecretRotationApplication.MARIADB_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSMariaDBRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme
 */
SecretRotationApplication.MARIADB_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSMariaDBRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme
 */
SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSMySQLRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme
 */
SecretRotationApplication.MYSQL_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSMySQLRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme
 */
SecretRotationApplication.ORACLE_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSOracleRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme
 */
SecretRotationApplication.ORACLE_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSOracleRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme
 */
SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSPostgreSQLRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme
 */
SecretRotationApplication.POSTGRES_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSPostgreSQLRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme
 */
SecretRotationApplication.SQLSERVER_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSSQLServerRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme
 */
SecretRotationApplication.SQLSERVER_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSSQLServerRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme
 */
SecretRotationApplication.REDSHIFT_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRedshiftRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme
 */
SecretRotationApplication.REDSHIFT_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRedshiftRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme
 */
SecretRotationApplication.MONGODB_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerMongoDBRotationSingleUser', '1.1.225');
/**
 * Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme
 */
SecretRotationApplication.MONGODB_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerMongoDBRotationMultiUser', '1.1.225', {
    isMultiUser: true,
});
/**
 * Secret rotation for a service or database
 */
class SecretRotation extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SecretRotationProps(props);
        if (!props.target.connections.defaultPort) {
            throw new Error('The `target` connections must have a default port range.');
        }
        if (props.application.isMultiUser && !props.masterSecret) {
            throw new Error('The `masterSecret` must be specified for application using the multi user scheme.');
        }
        // Max length of 64 chars, get the last 64 chars
        const uniqueId = core_1.Names.uniqueId(this);
        const rotationFunctionName = uniqueId.substring(Math.max(uniqueId.length - 64, 0), uniqueId.length);
        const securityGroup = props.securityGroup || new ec2.SecurityGroup(this, 'SecurityGroup', {
            vpc: props.vpc,
        });
        props.target.connections.allowDefaultPortFrom(securityGroup);
        const parameters = {
            endpoint: `https://${props.endpoint ? `${props.endpoint.vpcEndpointId}.` : ''}secretsmanager.${core_1.Stack.of(this).region}.${core_1.Stack.of(this).urlSuffix}`,
            functionName: rotationFunctionName,
            vpcSubnetIds: props.vpc.selectSubnets(props.vpcSubnets).subnetIds.join(','),
            vpcSecurityGroupIds: securityGroup.securityGroupId,
        };
        if (props.excludeCharacters !== undefined) {
            parameters.excludeCharacters = props.excludeCharacters;
        }
        if (props.secret.encryptionKey) {
            parameters.kmsKeyArn = props.secret.encryptionKey.keyArn;
        }
        if (props.masterSecret) {
            parameters.masterSecretArn = props.masterSecret.secretArn;
            if (props.masterSecret.encryptionKey) {
                parameters.masterSecretKmsKeyArn = props.masterSecret.encryptionKey.keyArn;
            }
        }
        const sarMapping = new core_1.CfnMapping(this, 'SARMapping', {
            mapping: {
                'aws': {
                    applicationId: props.application.applicationArnForPartition('aws'),
                    semanticVersion: props.application.semanticVersionForPartition('aws'),
                },
                'aws-cn': {
                    applicationId: props.application.applicationArnForPartition('aws-cn'),
                    semanticVersion: props.application.semanticVersionForPartition('aws-cn'),
                },
                'aws-us-gov': {
                    applicationId: props.application.applicationArnForPartition('aws-us-gov'),
                    semanticVersion: props.application.semanticVersionForPartition('aws-us-gov'),
                },
            },
        });
        const application = new serverless.CfnApplication(this, 'Resource', {
            location: {
                applicationId: sarMapping.findInMap(core_1.Aws.PARTITION, 'applicationId'),
                semanticVersion: sarMapping.findInMap(core_1.Aws.PARTITION, 'semanticVersion'),
            },
            parameters,
        });
        // This creates a CF a dependency between the rotation schedule and the
        // serverless application. This is needed because it's the application
        // that creates the Lambda permission to invoke the function.
        // See https://docs.aws.amazon.com/secretsmanager/latest/userguide/integrating_cloudformation.html
        const rotationLambda = lambda.Function.fromFunctionArn(this, 'RotationLambda', core_1.Token.asString(application.getAtt('Outputs.RotationLambdaARN')));
        props.secret.addRotationSchedule('RotationSchedule', {
            rotationLambda,
            automaticallyAfter: props.automaticallyAfter,
        });
        // Prevent master secret deletion when rotation is in place
        if (props.masterSecret) {
            props.masterSecret.denyAccountRootDelete();
        }
    }
}
exports.SecretRotation = SecretRotation;
_b = JSII_RTTI_SYMBOL_1;
SecretRotation[_b] = { fqn: "@aws-cdk/aws-secretsmanager.SecretRotation", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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