"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readTargetOptions = void 0;
// eslint-disable-next-line @typescript-eslint/no-restricted-imports
const params_1 = require("nx/src/utils/params");
const nx_1 = require("../../nx");
const { Workspaces } = (0, nx_1.requireNx)();
/**
 * Reads and combines options for a given target.
 *
 * Works as if you invoked the target yourself without passing any command lint overrides.
 */
function readTargetOptions({ project, target, configuration }, context) {
    var _a;
    const projectConfiguration = context.workspace.projects[project];
    const targetConfiguration = projectConfiguration.targets[target];
    const ws = new Workspaces(context.root);
    const [nodeModule, executorName] = targetConfiguration.executor.split(':');
    const { schema } = ws.readExecutor(nodeModule, executorName);
    const defaultProject = ws.calculateDefaultProjectName(context.cwd, { version: 2, projects: context.workspace.projects }, context.nxJsonConfiguration);
    return (0, params_1.combineOptionsForExecutor)({}, (_a = configuration !== null && configuration !== void 0 ? configuration : targetConfiguration.defaultConfiguration) !== null && _a !== void 0 ? _a : '', targetConfiguration, schema, defaultProject, ws.relativeCwd(context.cwd));
}
exports.readTargetOptions = readTargetOptions;
//# sourceMappingURL=read-target-options.js.map