from pydantic import BaseModel, ConfigDict, Field


class ClientVersion(BaseModel):
    latest_version: str = Field(alias="LatestVersion")

    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


class CurrentTailnet(BaseModel):
    magic_dns_enabled: bool = Field(alias="MagicDNSEnabled")
    magic_dns_suffix: str = Field(alias="MagicDNSSuffix")
    name: str = Field(alias="Name")

    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


class SelfInfo(BaseModel):
    online: bool = Field(alias="Online")

    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


class PeerInfo(BaseModel):
    active: bool = Field(alias="Active")
    exit_node: bool = Field(alias="ExitNode")
    exit_node_option: bool = Field(alias="ExitNodeOption")
    host_name: str = Field(alias="HostName")

    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


class TailscaleStatus(BaseModel):
    client_version: ClientVersion = Field(alias="ClientVersion")
    self_info: SelfInfo = Field(alias="Self")
    current_tailnet: CurrentTailnet = Field(alias="CurrentTailnet")
    peer: dict[str, PeerInfo] = Field(alias="Peer")

    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


# {'AuthURL': '',
#  'BackendState': 'Running',
#  'CertDomains': ['macbook-pro-von-pascal.taild5dd9e.ts.net'],
#  'ClientVersion': {'LatestVersion': '1.90.4'},
#  'CurrentTailnet': {'MagicDNSEnabled': True,
#                     'MagicDNSSuffix': 'taild5dd9e.ts.net',
#                     'Name': 'pascal736.github'},
#  'HaveNodeKey': True,
#  'Health': ['An update from version 1.86.4 to 1.90.4 is available.'],
#  'MagicDNSSuffix': 'taild5dd9e.ts.net',
#  'Peer': {'nodekey:0c3323a8c16c62e3131390c4f3de4b82a8de4f01bd82a9c2dad9feff7c48766c': {'Active': True,
#                                                                                        'Addrs': None,
#                                                                                        'AllowedIPs': ['100.72.118.109/32',
#                                                                                                       'fd7a:115c:a1e0::7c01:766d/128'],
#                                                                                        'Created': '2025-03-15T16:31:02.584350237Z',
#                                                                                        'CurAddr': '192.168.178.35:41641',
#                                                                                        'DNSName': 'green-meteor.taild5dd9e.ts.net.',
#                                                                                        'ExitNode': False,
#                                                                                        'ExitNodeOption': False,
#                                                                                        'HostName': 'green-meteor',
#                                                                                        'ID': 'nY8R1XGaV811CNTRL',
#                                                                                        'InEngine': True,
#                                                                                        'InMagicSock': True,
#                                                                                        'InNetworkMap': True,
#                                                                                        'LastHandshake': '2025-11-07T16:08:40.26736+01:00',
#                                                                                        'LastSeen': '2025-11-07T04:10:00.1Z',
#                                                                                        'LastWrite': '2025-11-03T07:00:13.819741166+01:00',
#                                                                                        'NoFileSharingReason': '',
#                                                                                        'OS': 'linux',
#                                                                                        'Online': True,
#                                                                                        'PeerAPIURL': ['http://100.72.118.109:50943',
#                                                                                                       'http://[fd7a:115c:a1e0::7c01:766d]:61616'],
#                                                                                        'PeerRelay': '',
#                                                                                        'PublicKey': 'nodekey:0c3323a8c16c62e3131390c4f3de4b82a8de4f01bd82a9c2dad9feff7c48766c',
#                                                                                        'Relay': 'fra',
#                                                                                        'RxBytes': 31489336,
#                                                                                        'TaildropTarget': 1,
#                                                                                        'TailscaleIPs': ['100.72.118.109',
#                                                                                                         'fd7a:115c:a1e0::7c01:766d'],
#                                                                                        'TxBytes': 29884232,
#                                                                                        'UserID': 1900669946660973,
#                                                                                        'sshHostKeys': ['ssh-rsa '
#                                                                                                        'AAAAB3NzaC1yc2EAAAADAQABAAABgQDG7nswo9XwilO5G7v/SOpoIutEyQkbKiyRDBbBbfcIDCTT8qnGpy6Dook4lm6EdkQhNg6v3SGhES0IV1lpDKSb6hG+DMqmcEJiP9I/OEqs4ej6Ug5CnjbIqy70E6DbJwhW9lYzeiowHrMCOWw1NivdGCgip5oW6BQVQyhCZN7hHeijRX0oMx5Mj7ttVNFes6YIHj7kkanUf2hHZp++KvO66DDdjty9yHu60FaVidWs3QI5fAw/2ZwIruECouOnax57cMHEuHv/+sqa9GMrE1cNgqB5sCex5T4vRCuSLF8uV84WCWF3xQZdd/0F38TV6gPB2QzD8JpRxAp5rbO5BROH+aOYI8RhCQzyWqo0Yn4bw12gBoJThMm2I6tfKNc8Wn2pWJ3U9xXpW1Nnx5s5N0RLIVG0+pCoZIvWww8Tno55ctdcw1wLqj1pK1OZqJGrk5a9RdfPU0COyUkPe0xBcA88ZAqL/pP2UyiTGTNUIDniqYBXkPQAWwdMQ4x9ON2Ges8=',
#                                                                                                        'ecdsa-sha2-nistp256 '
#                                                                                                        'AAAAE2VjZHNhLXNoYTItbmlzdHAyNTYAAAAIbmlzdHAyNTYAAABBBIKAWcfaZWA7Fg9qUk7z63hW1UfwikUS4Ha274gCfq1H4q6DbNov3J1dqUXxST9kejXUqRo/uHtJLrfLMEQ2jtg=',
#                                                                                                        'ssh-ed25519 '
#                                                                                                        'AAAAC3NzaC1lZDI1NTE5AAAAING0+qFA4cStGrwoYL1C+FJ8wxIFzCva9RdJnLz8yiF/']},
#           'nodekey:13821c023b1ea6940170207b13597cf7f8966a5aa9c713cd49b75b954fad8d25': {'Active': True,
#                                                                                        'Addrs': None,
#                                                                                        'AllowedIPs': ['100.109.141.38/32',
#                                                                                                       'fd7a:115c:a1e0::4f01:8d26/128'],
#                                                                                        'Created': '2025-03-15T16:31:01.72699161Z',
#                                                                                        'CurAddr': '192.168.178.47:41641',
#                                                                                        'DNSName': 'blue-star.taild5dd9e.ts.net.',
#                                                                                        'ExitNode': False,
#                                                                                        'ExitNodeOption': False,
#                                                                                        'HostName': 'blue-star',
#                                                                                        'ID': 'nzAvRsjrT411CNTRL',
#                                                                                        'InEngine': True,
#                                                                                        'InMagicSock': True,
#                                                                                        'InNetworkMap': True,
#                                                                                        'LastHandshake': '2025-11-07T16:07:53.82457+01:00',
#                                                                                        'LastSeen': '0001-01-01T00:00:00Z',
#                                                                                        'LastWrite': '2025-11-03T07:00:12.439020291+01:00',
#                                                                                        'NoFileSharingReason': '',
#                                                                                        'OS': 'linux',
#                                                                                        'Online': True,
#                                                                                        'PeerAPIURL': ['http://100.109.141.38:58010',
#                                                                                                       'http://[fd7a:115c:a1e0::4f01:8d26]:53470'],
#                                                                                        'PeerRelay': '',
#                                                                                        'PublicKey': 'nodekey:13821c023b1ea6940170207b13597cf7f8966a5aa9c713cd49b75b954fad8d25',
#                                                                                        'Relay': 'fra',
#                                                                                        'RxBytes': 501352,
#                                                                                        'TaildropTarget': 1,
#                                                                                        'TailscaleIPs': ['100.109.141.38',
#                                                                                                         'fd7a:115c:a1e0::4f01:8d26'],
#                                                                                        'TxBytes': 827900,
#                                                                                        'UserID': 1900669946660973,
#                                                                                        'sshHostKeys': ['ssh-rsa '
#                                                                                                        'AAAAB3NzaC1yc2EAAAADAQABAAABgQCm/4p4Vv92H8X+L17Racs8ZpwXhC36ahq1kAa8PVbrMdBCWnZoH0kSHvvtXWWTUJEcifhrAAXJYmlHtcT/RPiA+89yqRfwBCvC2qLQM/utuAkQaAEpPrZau0+9AQvnwPw02nCIC3DB5Jm1PyXJPbsRYZsUX0c/JF/g49xf6w9ZqU9XKFH1EXeaz6AQRRvyAS7l0bRQaE2sP1ZUJ2NAFeAebC3H9y43NBuN6ydgRpYAiVYPa+cZ1XKs45VB42GORYsQ67dxBDa6RYyoBMZY4XBDwJsKROBq8vAzSxiu9D0MXBaOPIyXObDV9MwwAP7RhUohCum5sdKvR24r+I0eCEwKTeRud3T3M+zVAIOvGIn+IQ22uRPFVcwYT9eHGiY1ygHPu4woncaFG/0cB56VUTsitIt21XCqsyf9Lc+XKpbGVfI0KISGK2hBoTqAiUh3xRmf99EZT9UJ88Mb3E18NPp8DQ/rMclbD5LXPv5+12TaokTJb7Ju1MB4el1ghThVhYU=',
#                                                                                                        'ecdsa-sha2-nistp256 '
#                                                                                                        'AAAAE2VjZHNhLXNoYTItbmlzdHAyNTYAAAAIbmlzdHAyNTYAAABBBGcwc8lw3pJkuC0b4hvgGi/zjje6UO1V9K64NOJSa537lUQXFCG+j6Ufmo1R2xWf4ZQXV29Y8OkxXzlO3Dg8+qU=',
#                                                                                                        'ssh-ed25519 '
#                                                                                                        'AAAAC3NzaC1lZDI1NTE5AAAAIM1AKQZBZGs4WNv0t2zV1DPSJG7QBvBThqVM3/ccSX3V']},
#           'nodekey:282ec64d4e1167607f5a97e21516c67511088f2bac47088d1ab1b4f020d99c45': {'Active': False,
#                                                                                        'Addrs': None,
#                                                                                        'AllowedIPs': ['100.89.156.70/32',
#                                                                                                       'fd7a:115c:a1e0::2001:9c47/128'],
#                                                                                        'Created': '2025-08-05T12:02:20.683252504Z',
#                                                                                        'CurAddr': '',
#                                                                                        'DNSName': 'tablet.taild5dd9e.ts.net.',
#                                                                                        'ExitNode': False,
#                                                                                        'ExitNodeOption': False,
#                                                                                        'HostName': 'localhost',
#                                                                                        'ID': 'nNkLmesPnX11CNTRL',
#                                                                                        'InEngine': False,
#                                                                                        'InMagicSock': True,
#                                                                                        'InNetworkMap': True,
#                                                                                        'KeyExpiry': '2026-02-01T12:02:20Z',
#                                                                                        'LastHandshake': '0001-01-01T00:00:00Z',
#                                                                                        'LastSeen': '2025-11-07T04:10:00.1Z',
#                                                                                        'LastWrite': '2025-11-03T05:46:50.197425416+01:00',
#                                                                                        'NoFileSharingReason': '',
#                                                                                        'OS': 'android',
#                                                                                        'Online': True,
#                                                                                        'PeerAPIURL': ['http://100.89.156.70:1',
#                                                                                                       'http://[fd7a:115c:a1e0::2001:9c47]:1'],
#                                                                                        'PeerRelay': '',
#                                                                                        'PublicKey': 'nodekey:282ec64d4e1167607f5a97e21516c67511088f2bac47088d1ab1b4f020d99c45',
#                                                                                        'Relay': 'fra',
#                                                                                        'RxBytes': 0,
#                                                                                        'TaildropTarget': 1,
#                                                                                        'TailscaleIPs': ['100.89.156.70',
#                                                                                                         'fd7a:115c:a1e0::2001:9c47'],
#                                                                                        'TxBytes': 0,
#                                                                                        'UserID': 1900669946660973},
#           'nodekey:53764601cc5aa3070998a3368084aeb04b4666a9e3352b9e967230772b7c8213': {'Active': False,
#                                                                                        'Addrs': None,
#                                                                                        'AllowedIPs': ['100.103.99.102/32',
#                                                                                                       'fd7a:115c:a1e0::9b01:6366/128'],
#                                                                                        'Created': '2024-10-23T17:54:22.697825142Z',
#                                                                                        'CurAddr': '',
#                                                                                        'DNSName': 'iphone-11.taild5dd9e.ts.net.',
#                                                                                        'ExitNode': False,
#                                                                                        'ExitNodeOption': False,
#                                                                                        'HostName': 'localhost',
#                                                                                        'ID': 'nWXpoF9Bx421CNTRL',
#                                                                                        'InEngine': False,
#                                                                                        'InMagicSock': True,
#                                                                                        'InNetworkMap': True,
#                                                                                        'KeyExpiry': '2026-01-31T14:18:46Z',
#                                                                                        'LastHandshake': '0001-01-01T00:00:00Z',
#                                                                                        'LastSeen': '2025-11-07T04:10:00.1Z',
#                                                                                        'LastWrite': '2025-11-03T06:51:45.319403583+01:00',
#                                                                                        'NoFileSharingReason': '',
#                                                                                        'OS': 'iOS',
#                                                                                        'Online': True,
#                                                                                        'PeerAPIURL': ['http://100.103.99.102:63678',
#                                                                                                       'http://[fd7a:115c:a1e0::9b01:6366]:53036'],
#                                                                                        'PeerRelay': '',
#                                                                                        'PublicKey': 'nodekey:53764601cc5aa3070998a3368084aeb04b4666a9e3352b9e967230772b7c8213',
#                                                                                        'Relay': 'fra',
#                                                                                        'RxBytes': 0,
#                                                                                        'TaildropTarget': 1,
#                                                                                        'TailscaleIPs': ['100.103.99.102',
#                                                                                                         'fd7a:115c:a1e0::9b01:6366'],
#                                                                                        'TxBytes': 0,
#                                                                                        'UserID': 1900669946660973},
#           'nodekey:a3f0949ed2566a8af6ae0017f67983db32a55c24743c33625b2350baff0fcd33': {'Active': False,
#                                                                                        'Addrs': None,
#                                                                                        'AllowedIPs': ['100.79.205.52/32',
#                                                                                                       'fd7a:115c:a1e0::ff01:cd35/128',
#                                                                                                       '0.0.0.0/0',
#                                                                                                       '::/0'],
#                                                                                        'CapMap': {'suggest-exit-node': None},
#                                                                                        'Created': '2025-03-15T16:28:59.4985702Z',
#                                                                                        'CurAddr': '',
#                                                                                        'DNSName': 'black-moon.taild5dd9e.ts.net.',
#                                                                                        'ExitNode': False,
#                                                                                        'ExitNodeOption': True,
#                                                                                        'HostName': 'black-moon',
#                                                                                        'ID': 'nFokBKmmnv11CNTRL',
#                                                                                        'InEngine': True,
#                                                                                        'InMagicSock': True,
#                                                                                        'InNetworkMap': True,
#                                                                                        'LastHandshake': '2025-11-07T15:33:19.849507+01:00',
#                                                                                        'LastSeen': '0001-01-01T00:00:00Z',
#                                                                                        'LastWrite': '2025-11-03T06:51:25.59467225+01:00',
#                                                                                        'NoFileSharingReason': '',
#                                                                                        'OS': 'linux',
#                                                                                        'Online': True,
#                                                                                        'PeerAPIURL': ['http://100.79.205.52:52825',
#                                                                                                       'http://[fd7a:115c:a1e0::ff01:cd35]:56837'],
#                                                                                        'PeerRelay': '',
#                                                                                        'PublicKey': 'nodekey:a3f0949ed2566a8af6ae0017f67983db32a55c24743c33625b2350baff0fcd33',
#                                                                                        'Relay': 'fra',
#                                                                                        'RxBytes': 892,
#                                                                                        'TaildropTarget': 1,
#                                                                                        'TailscaleIPs': ['100.79.205.52',
#                                                                                                         'fd7a:115c:a1e0::ff01:cd35'],
#                                                                                        'TxBytes': 1004,
#                                                                                        'UserID': 1900669946660973,
#                                                                                        'sshHostKeys': ['ssh-rsa '
#                                                                                                        'AAAAB3NzaC1yc2EAAAADAQABAAABgQDPJ2CjtXx44aVOE1qjGQJOyIPw8QhXydbaMT/uBj1yws8miBH6C4xVP9uPYAysDGejn6VIb//+dmovu95johuE+uKIiDy4Av9WR+YCL0gIwnTQgBmcdOIbBpCuj3fK2NhJwYGAwHi92ibZbbRZFrPbbdtIKDM2IWIJnnj2rPl7VjWV41oVjgYugTXwLbystTehQWRQut7S0EHcfEx2vNPaUvjBMpJs5LhE2hfznfK9/2S0KHBQF0NYDgN5YCRdSc/s4UtXst7V7zqNS1qXreqBvhLHqfYm4SajtL0JAhegEFZrxJDP34cZn4UfdBHfqyF0j0uoLWvw3KTlCUgzGfIdRl7zoxpAqFsPac7WlM7NgjcWEWIJmqBwOk8im43BqNgmiF/SXAs7cgCFh2J8QkrpojTvLrEIypTbtZTDNrIlUtWqQ5U1k9sg8qJ6OmNw6Q6eq66lo6L0IlWBDYoD8+eUG/dNwJ6R/cneeXgQoAVqBPKQibd5Ly16XAf2QvNaqLE=',
#                                                                                                        'ecdsa-sha2-nistp256 '
#                                                                                                        'AAAAE2VjZHNhLXNoYTItbmlzdHAyNTYAAAAIbmlzdHAyNTYAAABBBBgiZ7003iCTEx6VTu42/xmvOI1f6Z+OiTI3GalVCpSvpW6tlQu65TMDuKba0M7TkkgXbyW4FR3MAUVffFR8lEY=',
#                                                                                                        'ssh-ed25519 '
#                                                                                                        'AAAAC3NzaC1lZDI1NTE5AAAAIOlSO2FrPfTfUyad6kfXkfoI4d9de55h800oLLn3JubF']}},
#  'Self': {'Active': False,
#           'Addrs': ['87.144.255.241:59024',
#                     '[2003:cb:172e:b200:3db2:78e5:b148:33da]:41641',
#                     '10.42.1.2:41641',
#                     '192.168.178.63:41641',
#                     '[2003:cb:172e:b200:412:4b61:9b10:b23a]:41641'],
#           'AllowedIPs': ['100.119.33.10/32', 'fd7a:115c:a1e0::4301:210a/128'],
#           'CapMap': {'funnel': None,
#                      'https': None,
#                      'https://tailscale.com/cap/file-sharing': None,
#                      'https://tailscale.com/cap/funnel-ports?ports=443,8443,10000': None,
#                      'https://tailscale.com/cap/is-admin': None,
#                      'https://tailscale.com/cap/is-owner': None,
#                      'https://tailscale.com/cap/ssh': None,
#                      'https://tailscale.com/cap/tailnet-lock': None,
#                      'probe-udp-lifetime': None,
#                      'ssh-behavior-v1': None,
#                      'ssh-env-vars': None,
#                      'store-appc-routes': None},
#           'Capabilities': ['HTTPS://TAILSCALE.COM/s/DEPRECATED-NODE-CAPS#see-https://github.com/tailscale/tailscale/issues/11508',
#                            'funnel',
#                            'https',
#                            'https://tailscale.com/cap/file-sharing',
#                            'https://tailscale.com/cap/funnel-ports?ports=443,8443,10000',
#                            'https://tailscale.com/cap/is-admin',
#                            'https://tailscale.com/cap/is-owner',
#                            'https://tailscale.com/cap/ssh',
#                            'https://tailscale.com/cap/tailnet-lock',
#                            'probe-udp-lifetime',
#                            'ssh-behavior-v1',
#                            'ssh-env-vars',
#                            'store-appc-routes'],
#           'Created': '2024-10-23T17:49:40.185981501Z',
#           'CurAddr': '',
#           'DNSName': 'macbook-pro-von-pascal.taild5dd9e.ts.net.',
#           'ExitNode': False,
#           'ExitNodeOption': False,
#           'HostName': 'MacBook Pro von Pascal',
#           'ID': 'nvbJLtJirH11CNTRL',
#           'InEngine': False,
#           'InMagicSock': False,
#           'InNetworkMap': True,
#           'KeyExpiry': '2025-11-25T10:06:21Z',
#           'LastHandshake': '0001-01-01T00:00:00Z',
#           'LastSeen': '0001-01-01T00:00:00Z',
#           'LastWrite': '0001-01-01T00:00:00Z',
#           'NoFileSharingReason': '',
#           'OS': 'macOS',
#           'Online': True,
#           'PeerAPIURL': ['http://100.119.33.10:56122',
#                          'http://[fd7a:115c:a1e0::4301:210a]:53208'],
#           'PeerRelay': '',
#           'PublicKey': 'nodekey:eaadd7a870bbff5dc809c29bf609bb97e1c5da63f33f8a2aa92ba214d0093959',
#           'Relay': 'fra',
#           'RxBytes': 0,
#           'TaildropTarget': 0,
#           'TailscaleIPs': ['100.119.33.10', 'fd7a:115c:a1e0::4301:210a'],
#           'TxBytes': 0,
#           'UserID': 1900669946660973},
#  'TUN': True,
#  'TailscaleIPs': ['100.119.33.10', 'fd7a:115c:a1e0::4301:210a'],
#  'User': {'1900669946660973': {'DisplayName': 'Pascal736',
#                                'ID': 1900669946660973,
#                                'LoginName': 'Pascal736@github',
#                                'ProfilePicURL': 'https://avatars.githubusercontent.com/u/76991455?v=4'}},
#  'Version':86.4-t3149aad97-g60158502b'}
