# Code generated by generate_api.py. DO NOT EDIT.
# Client library for Diagonal's geospatial analysis engine, b6.

from __future__ import annotations

from typing import Callable

import diagonal_b6.expression
from diagonal_b6.expression import Call, Symbol, Lambda, Result

VERSION = '0.0.2+modified'

class CollectionTraits:

    def take(self, a0: IntTraits) -> CollectionResult:
        return take(self, a0)

    def map_items(self, a0: Callable[[PairTraits],AnyTraits]) -> CollectionResult:
        return map_items(self, a0)

    def count_values(self) -> CollectionResult:
        return count_values(self)

    def map_parallel(self, a0: Callable[[AnyTraits],AnyTraits]) -> CollectionResult:
        return map_parallel(self, a0)

    def sum_by_key(self) -> CollectionResult:
        return sum_by_key(self)

    def count(self) -> IntTraits:
        return count(self)

    def filter(self, a0: Callable[[AnyTraits],BoolTraits]) -> CollectionResult:
        return filter(self, a0)

    def flattern(self) -> CollectionResult:
        return flattern(self)

    def map(self, a0: Callable[[AnyTraits],AnyTraits]) -> CollectionResult:
        return map(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class RenderableTraits:

    def to_geojson(self) -> GeoJSONTraits:
        return to_geojson(self)

    @classmethod
    def _collection(cls):
        return AnyRenderableCollectionResult

class RenderableValuesTraits:

    def to_geojson(self) -> CollectionTraits:
        return self.map(Lambda(to_geojson, [self._values()]))

class AnyRenderableValuesResult(Result, RenderableValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return RenderableResult

class GeometryTraits(RenderableTraits):

    def centroid(self) -> PointTraits:
        return centroid(self)

    def points(self) -> PointCollectionResult:
        return points(self)

    def intersecting(self) -> QueryTraits:
        return intersecting(self)

    def tile_paths(self, a0: IntTraits) -> IntStringCollectionResult:
        return tile_paths(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class GeometryValuesTraits(RenderableValuesTraits):

    def centroid(self) -> PointCollectionTraits:
        return self.map(Lambda(centroid, [self._values()]))

    def points(self) -> CollectionTraits:
        return self.map(Lambda(points, [self._values()]))

    def intersecting(self) -> CollectionTraits:
        return self.map(Lambda(intersecting, [self._values()]))

    def tile_paths(self, a0: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: tile_paths(x, a0), [self._values()]))

class AnyGeometryValuesResult(Result, GeometryValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return GeometryResult

class IdentifiableTraits:

    def get_string(self, a0: StringTraits) -> StringTraits:
        return get_string(self, a0)

    def add_tag(self, a0: TagTraits) -> ChangeTraits:
        return add_tag(self, a0)

    def get(self, a0: StringTraits) -> TagTraits:
        return get(self, a0)

    def all_tags(self) -> IntTagCollectionResult:
        return all_tags(self)

    def debug_tokens(self) -> IntStringCollectionResult:
        return debug_tokens(self)

    def get_int(self, a0: StringTraits) -> IntTraits:
        return get_int(self, a0)

    def count_tag_value(self, a0: StringTraits) -> CollectionResult:
        return count_tag_value(self, a0)

    def get_float(self, a0: StringTraits) -> FloatTraits:
        return get_float(self, a0)

    def remove_tag(self, a0: StringTraits) -> ChangeTraits:
        return remove_tag(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class IdentifiableValuesTraits:

    def get_string(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: get_string(x, a0), [self._values()]))

    def add_tag(self, a0: TagTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: add_tag(x, a0), [self._values()]))

    def get(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: get(x, a0), [self._values()]))

    def all_tags(self) -> CollectionTraits:
        return self.map(Lambda(all_tags, [self._values()]))

    def debug_tokens(self) -> CollectionTraits:
        return self.map(Lambda(debug_tokens, [self._values()]))

    def get_int(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: get_int(x, a0), [self._values()]))

    def count_tag_value(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: count_tag_value(x, a0), [self._values()]))

    def get_float(self, a0: StringTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: get_float(x, a0), [self._values()]))

    def remove_tag(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: remove_tag(x, a0), [self._values()]))

class AnyIdentifiableValuesResult(Result, IdentifiableValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return IdentifiableResult

class FeatureTraits(IdentifiableTraits, RenderableTraits):

    def closest_distance(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> FloatTraits:
        return closest_distance(self, a0, a1, a2)

    def has_key(self, a0: StringTraits) -> BoolTraits:
        return has_key(self, a0)

    def paths_to_reach(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> FeatureIDIntCollectionResult:
        return paths_to_reach(self, a0, a1, a2)

    def reachable(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> FeatureCollectionResult:
        return reachable(self, a0, a1, a2)

    def point_features(self) -> PointFeatureCollectionResult:
        return point_features(self)

    def tile_ids(self) -> FeatureIDIntCollectionResult:
        return tile_ids(self)

    def reachable_points(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> PointFeatureCollectionResult:
        return reachable_points(self, a0, a1, a2)

    def closest(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> FeatureTraits:
        return closest(self, a0, a1, a2)

    def tile_ids_hex(self) -> FeatureIDStringCollectionResult:
        return tile_ids_hex(self)

    def reachable_area(self, a0: StringTraits, a1: FloatTraits) -> FloatTraits:
        return reachable_area(self, a0, a1)

    def connect_to_network(self) -> ChangeTraits:
        return connect_to_network(self)

    @classmethod
    def _collection(cls):
        return FeatureCollectionResult

class FeatureValuesTraits(IdentifiableValuesTraits, RenderableValuesTraits):

    def closest_distance(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: closest_distance(x, a0, a1, a2), [self._values()]))

    def has_key(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: has_key(x, a0), [self._values()]))

    def paths_to_reach(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: paths_to_reach(x, a0, a1, a2), [self._values()]))

    def reachable(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: reachable(x, a0, a1, a2), [self._values()]))

    def point_features(self) -> CollectionTraits:
        return self.map(Lambda(point_features, [self._values()]))

    def tile_ids(self) -> CollectionTraits:
        return self.map(Lambda(tile_ids, [self._values()]))

    def reachable_points(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: reachable_points(x, a0, a1, a2), [self._values()]))

    def closest(self, a0: StringTraits, a1: FloatTraits, a2: QueryTraits) -> FeatureCollectionTraits:
        return self.map(Lambda(lambda x: closest(x, a0, a1, a2), [self._values()]))

    def tile_ids_hex(self) -> CollectionTraits:
        return self.map(Lambda(tile_ids_hex, [self._values()]))

    def reachable_area(self, a0: StringTraits, a1: FloatTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: reachable_area(x, a0, a1), [self._values()]))

    def connect_to_network(self) -> CollectionTraits:
        return self.map(Lambda(connect_to_network, [self._values()]))

class AnyFeatureValuesResult(Result, FeatureValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FeatureResult

class NumberTraits:

    def divide(self, a0: NumberTraits) -> NumberTraits:
        return divide(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class NumberValuesTraits:

    def divide(self, a0: NumberTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: divide(x, a0), [self._values()]))

class AnyNumberValuesResult(Result, NumberValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return NumberResult

class AreaTraits(GeometryTraits):

    def area(self) -> FloatTraits:
        return area(self)

    def s2_points(self, a0: IntTraits, a1: IntTraits) -> StringPointCollectionResult:
        return s2_points(self, a0, a1)

    def snap_area_edges(self, a0: QueryTraits, a1: FloatTraits) -> AreaTraits:
        return snap_area_edges(self, a0, a1)

    def within(self) -> QueryTraits:
        return within(self)

    def s2_covering(self, a0: IntTraits, a1: IntTraits) -> StringStringCollectionResult:
        return s2_covering(self, a0, a1)

    def s2_grid(self, a0: IntTraits) -> StringStringCollectionResult:
        return s2_grid(self, a0)

    @classmethod
    def _collection(cls):
        return AreaCollectionResult

class AreaValuesTraits(GeometryValuesTraits):

    def area(self) -> AnyFloatCollectionTraits:
        return self.map(Lambda(area, [self._values()]))

    def s2_points(self, a0: IntTraits, a1: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: s2_points(x, a0, a1), [self._values()]))

    def snap_area_edges(self, a0: QueryTraits, a1: FloatTraits) -> AreaCollectionTraits:
        return self.map(Lambda(lambda x: snap_area_edges(x, a0, a1), [self._values()]))

    def within(self) -> CollectionTraits:
        return self.map(Lambda(within, [self._values()]))

    def s2_covering(self, a0: IntTraits, a1: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: s2_covering(x, a0, a1), [self._values()]))

    def s2_grid(self, a0: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: s2_grid(x, a0), [self._values()]))

class AnyAreaValuesResult(Result, AreaValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AreaResult

class PointTraits(GeometryTraits):

    def cap_polygon(self, a0: FloatTraits) -> AreaTraits:
        return cap_polygon(self, a0)

    def distance_meters(self, a0: PointTraits) -> FloatTraits:
        return distance_meters(self, a0)

    def intersecting_cap(self, a0: FloatTraits) -> QueryTraits:
        return intersecting_cap(self, a0)

    def add_point(self, a0: StringPointCollectionResult) -> StringPointCollectionResult:
        return add_point(self, a0)

    def within_cap(self, a0: FloatTraits) -> QueryTraits:
        return within_cap(self, a0)

    def rectangle_polygon(self, a0: PointTraits) -> AreaTraits:
        return rectangle_polygon(self, a0)

    def sightline(self, a0: FloatTraits) -> AreaTraits:
        return sightline(self, a0)

    @classmethod
    def _collection(cls):
        return PointCollectionResult

class PointValuesTraits(GeometryValuesTraits):

    def cap_polygon(self, a0: FloatTraits) -> AreaCollectionTraits:
        return self.map(Lambda(lambda x: cap_polygon(x, a0), [self._values()]))

    def distance_meters(self, a0: PointTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: distance_meters(x, a0), [self._values()]))

    def intersecting_cap(self, a0: FloatTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: intersecting_cap(x, a0), [self._values()]))

    def add_point(self, a0: StringPointCollectionResult) -> CollectionTraits:
        return self.map(Lambda(lambda x: add_point(x, a0), [self._values()]))

    def within_cap(self, a0: FloatTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: within_cap(x, a0), [self._values()]))

    def rectangle_polygon(self, a0: PointTraits) -> AreaCollectionTraits:
        return self.map(Lambda(lambda x: rectangle_polygon(x, a0), [self._values()]))

    def sightline(self, a0: FloatTraits) -> AreaCollectionTraits:
        return self.map(Lambda(lambda x: sightline(x, a0), [self._values()]))

class AnyPointValuesResult(Result, PointValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PointResult

class StringTraits:

    def s2_polygon(self) -> AreaTraits:
        return s2_polygon(self)

    def tagged(self, a0: StringTraits) -> QueryTraits:
        return tagged(self, a0)

    def debug_all_query(self) -> QueryTraits:
        return debug_all_query(self)

    def keyed(self) -> QueryTraits:
        return keyed(self)

    def tag(self, a0: StringTraits) -> TagTraits:
        return tag(self, a0)

    def parse_geojson(self) -> GeoJSONTraits:
        return parse_geojson(self)

    def import_geojson_file(self, a0: StringTraits) -> ChangeTraits:
        return import_geojson_file(self, a0)

    def s2_center(self) -> PointTraits:
        return s2_center(self)

    def export_world(self) -> IntTraits:
        return export_world(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class StringValuesTraits:

    def s2_polygon(self) -> AreaCollectionTraits:
        return self.map(Lambda(s2_polygon, [self._values()]))

    def tagged(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: tagged(x, a0), [self._values()]))

    def debug_all_query(self) -> CollectionTraits:
        return self.map(Lambda(debug_all_query, [self._values()]))

    def keyed(self) -> CollectionTraits:
        return self.map(Lambda(keyed, [self._values()]))

    def tag(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: tag(x, a0), [self._values()]))

    def parse_geojson(self) -> CollectionTraits:
        return self.map(Lambda(parse_geojson, [self._values()]))

    def import_geojson_file(self, a0: StringTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: import_geojson_file(x, a0), [self._values()]))

    def s2_center(self) -> PointCollectionTraits:
        return self.map(Lambda(s2_center, [self._values()]))

    def export_world(self) -> CollectionTraits:
        return self.map(Lambda(export_world, [self._values()]))

class AnyStringValuesResult(Result, StringValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return StringResult

class PathTraits(GeometryTraits):

    def ordered_join(self, a0: PathTraits) -> PathTraits:
        return ordered_join(self, a0)

    def join(self, a0: PathTraits) -> PathTraits:
        return join(self, a0)

    def sample_points(self, a0: FloatTraits) -> StringPointCollectionResult:
        return sample_points(self, a0)

    def distance_to_point_meters(self, a0: PointTraits) -> FloatTraits:
        return distance_to_point_meters(self, a0)

    def interpolate(self, a0: FloatTraits) -> PointTraits:
        return interpolate(self, a0)

    @classmethod
    def _collection(cls):
        return PathCollectionResult

class PathValuesTraits(GeometryValuesTraits):

    def ordered_join(self, a0: PathTraits) -> PathCollectionTraits:
        return self.map(Lambda(lambda x: ordered_join(x, a0), [self._values()]))

    def join(self, a0: PathTraits) -> PathCollectionTraits:
        return self.map(Lambda(lambda x: join(x, a0), [self._values()]))

    def sample_points(self, a0: FloatTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: sample_points(x, a0), [self._values()]))

    def distance_to_point_meters(self, a0: PointTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: distance_to_point_meters(x, a0), [self._values()]))

    def interpolate(self, a0: FloatTraits) -> PointCollectionTraits:
        return self.map(Lambda(lambda x: interpolate(x, a0), [self._values()]))

class AnyPathValuesResult(Result, PathValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PathResult

class TagTraits:

    def float_value(self) -> FloatTraits:
        return float_value(self)

    def value(self) -> StringTraits:
        return value(self)

    def int_value(self) -> IntTraits:
        return int_value(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class TagValuesTraits:

    def float_value(self) -> AnyFloatCollectionTraits:
        return self.map(Lambda(float_value, [self._values()]))

    def value(self) -> CollectionTraits:
        return self.map(Lambda(value, [self._values()]))

    def int_value(self) -> CollectionTraits:
        return self.map(Lambda(int_value, [self._values()]))

class AnyTagValuesResult(Result, TagValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return TagResult

class IdentifiablePointTraits:

    def point_paths(self) -> PathFeatureCollectionResult:
        return point_paths(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class IdentifiablePointValuesTraits:

    def point_paths(self) -> CollectionTraits:
        return self.map(Lambda(point_paths, [self._values()]))

class AnyIdentifiablePointValuesResult(Result, IdentifiablePointValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return IdentifiablePointResult

class AreaFeatureTraits(AreaTraits, FeatureTraits):
    @classmethod
    def _collection(cls):
        return AreaFeatureCollectionResult

class AreaFeatureValuesTraits(AreaValuesTraits, FeatureValuesTraits):
    pass

class AnyAreaFeatureValuesResult(Result, AreaFeatureValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AreaFeatureResult

class AnyTraits:

    def pair(self, a0: AnyTraits) -> PairTraits:
        return pair(self, a0)

    def gt(self, a0: AnyTraits) -> BoolTraits:
        return gt(self, a0)

    def collection(self, a0: AnyTraits) -> CollectionResult:
        return collection(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class AnyValuesTraits:

    def pair(self, a0: AnyTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: pair(x, a0), [self._values()]))

    def gt(self, a0: AnyTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: gt(x, a0), [self._values()]))

    def collection(self, a0: AnyTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: collection(x, a0), [self._values()]))

class AnyAnyValuesResult(Result, AnyValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AnyResult

class PointFeatureTraits(PointTraits, IdentifiablePointTraits, FeatureTraits):

    def degree(self) -> IntTraits:
        return degree(self)

    def connect(self, a0: PointFeatureTraits) -> ChangeTraits:
        return connect(self, a0)

    @classmethod
    def _collection(cls):
        return PointFeatureCollectionResult

class PointFeatureValuesTraits(PointValuesTraits, IdentifiablePointValuesTraits, FeatureValuesTraits):

    def degree(self) -> CollectionTraits:
        return self.map(Lambda(degree, [self._values()]))

    def connect(self, a0: PointFeatureTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: connect(x, a0), [self._values()]))

class AnyPointFeatureValuesResult(Result, PointFeatureValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PointFeatureResult

class RelationFeatureTraits(FeatureTraits, GeometryTraits):
    @classmethod
    def _collection(cls):
        return RelationFeatureCollectionResult

class RelationFeatureValuesTraits(FeatureValuesTraits, GeometryValuesTraits):
    pass

class AnyRelationFeatureValuesResult(Result, RelationFeatureValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return RelationFeatureResult

class FloatTraits(NumberTraits):

    def ll(self, a0: FloatTraits) -> PointTraits:
        return ll(self, a0)

    @classmethod
    def _collection(cls):
        return AnyFloatCollectionResult

class FloatValuesTraits(NumberValuesTraits):

    def ll(self, a0: FloatTraits) -> PointCollectionTraits:
        return self.map(Lambda(lambda x: ll(x, a0), [self._values()]))

class AnyFloatValuesResult(Result, FloatValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FloatResult

class PointCollectionTraits(CollectionTraits, PointValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class IntTraits(NumberTraits):

    def clamp(self, a0: IntTraits, a1: IntTraits) -> IntTraits:
        return clamp(self, a0, a1)

    def add_ints(self, a0: IntTraits) -> IntTraits:
        return add_ints(self, a0)

    def divide_int(self, a0: FloatTraits) -> FloatTraits:
        return divide_int(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class IntValuesTraits(NumberValuesTraits):

    def clamp(self, a0: IntTraits, a1: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: clamp(x, a0, a1), [self._values()]))

    def add_ints(self, a0: IntTraits) -> CollectionTraits:
        return self.map(Lambda(lambda x: add_ints(x, a0), [self._values()]))

    def divide_int(self, a0: FloatTraits) -> AnyFloatCollectionTraits:
        return self.map(Lambda(lambda x: divide_int(x, a0), [self._values()]))

class AnyIntValuesResult(Result, IntValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return IntResult

class PathFeatureTraits(PathTraits, FeatureTraits):

    def length(self) -> FloatTraits:
        return length(self)

    @classmethod
    def _collection(cls):
        return PathFeatureCollectionResult

class PathFeatureValuesTraits(PathValuesTraits, FeatureValuesTraits):

    def length(self) -> AnyFloatCollectionTraits:
        return self.map(Lambda(length, [self._values()]))

class AnyPathFeatureValuesResult(Result, PathFeatureValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PathFeatureResult

class FeatureIDTraits(IdentifiableTraits):

    def find_feature(self) -> FeatureTraits:
        return find_feature(self)

    def find_point(self) -> PointFeatureTraits:
        return find_point(self)

    def find_area(self) -> AreaFeatureTraits:
        return find_area(self)

    def find_path(self) -> PathFeatureTraits:
        return find_path(self)

    def find_relation(self) -> RelationFeatureTraits:
        return find_relation(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureIDValuesTraits(IdentifiableValuesTraits):

    def find_feature(self) -> FeatureCollectionTraits:
        return self.map(Lambda(find_feature, [self._values()]))

    def find_point(self) -> PointFeatureCollectionTraits:
        return self.map(Lambda(find_point, [self._values()]))

    def find_area(self) -> AreaFeatureCollectionTraits:
        return self.map(Lambda(find_area, [self._values()]))

    def find_path(self) -> PathFeatureCollectionTraits:
        return self.map(Lambda(find_path, [self._values()]))

    def find_relation(self) -> RelationFeatureCollectionTraits:
        return self.map(Lambda(find_relation, [self._values()]))

class AnyFeatureIDValuesResult(Result, FeatureIDValuesTraits, CollectionTraits):

    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FeatureIDResult

class AreaCollectionTraits(CollectionTraits, AreaValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class PathCollectionTraits(CollectionTraits, PathValuesTraits):

    def sample_points_along_paths(self, a0: FloatTraits) -> PointCollectionResult:
        return sample_points_along_paths(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class AnyRenderableCollectionTraits(CollectionTraits, RenderableValuesTraits):

    def to_geojson_collection(self) -> GeoJSONTraits:
        return to_geojson_collection(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class QueryProtoTraits:
    @classmethod
    def _collection(cls):
        return CollectionResult

class StringPointCollectionTraits(CollectionTraits, PointValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class IntStringCollectionTraits(CollectionTraits, StringValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class RelationFeatureCollectionTraits(CollectionTraits, RelationFeatureValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class AnyFloatCollectionTraits(CollectionTraits, FloatValuesTraits):

    def percentiles(self) -> AnyFloatCollectionResult:
        return percentiles(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class PointFeatureCollectionTraits(PointCollectionTraits, PointFeatureValuesTraits):

    def containing_areas(self, a0: QueryTraits) -> AreaFeatureCollectionResult:
        return containing_areas(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class StringStringCollectionTraits(CollectionTraits, StringValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class AreaFeatureCollectionTraits(AreaCollectionTraits, AreaFeatureValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class StringAreaCollectionTraits(CollectionTraits, AreaValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureCollectionTraits(CollectionTraits, FeatureValuesTraits):

    def building_access(self, a0: FloatTraits, a1: StringTraits) -> FeatureIDFeatureIDCollectionResult:
        return building_access(self, a0, a1)

    @classmethod
    def _collection(cls):
        return CollectionResult

class IntTagCollectionTraits(CollectionTraits, TagValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class GeoJSONTraits:

    def geojson_areas(self) -> StringAreaCollectionResult:
        return geojson_areas(self)

    def map_geometries(self, a0: Callable[[GeometryTraits],GeometryTraits]) -> GeoJSONTraits:
        return map_geometries(self, a0)

    def import_geojson(self, a0: StringTraits) -> ChangeTraits:
        return import_geojson(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureIDIntCollectionTraits(CollectionTraits, IntValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class QueryTraits:

    def and_(self, a0: QueryTraits) -> QueryTraits:
        return and_(self, a0)

    def find_areas(self) -> AreaFeatureCollectionResult:
        return find_areas(self)

    def find_points(self) -> PointFeatureCollectionResult:
        return find_points(self)

    def or_(self, a0: QueryTraits) -> QueryTraits:
        return or_(self, a0)

    def find_relations(self) -> RelationFeatureCollectionResult:
        return find_relations(self)

    def find_paths(self) -> PathFeatureCollectionResult:
        return find_paths(self)

    def find(self) -> FeatureCollectionResult:
        return find(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class BoolTraits:
    @classmethod
    def _collection(cls):
        return CollectionResult

class PairTraits:

    def second(self) -> AnyTraits:
        return second(self)

    def first(self) -> AnyTraits:
        return first(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class PathFeatureCollectionTraits(PathCollectionTraits, PathFeatureValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureIDTagCollectionTraits(CollectionTraits, TagValuesTraits):

    def add_tags(self) -> ChangeTraits:
        return add_tags(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureIDStringCollectionTraits(CollectionTraits, StringValuesTraits):

    def remove_tags(self) -> ChangeTraits:
        return remove_tags(self)

    @classmethod
    def _collection(cls):
        return CollectionResult

class FeatureIDFeatureIDCollectionTraits(CollectionTraits, FeatureIDValuesTraits):
    @classmethod
    def _collection(cls):
        return CollectionResult

class ChangeTraits:

    def with_change(self, a0: Callable[[],AnyTraits]) -> AnyTraits:
        return with_change(self, a0)

    @classmethod
    def _collection(cls):
        return CollectionResult

class CollectionResult(Result, CollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AnyResult

class RenderableResult(Result, RenderableTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class GeometryResult(Result, GeometryTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class IdentifiableResult(Result, IdentifiableTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class FeatureResult(Result, FeatureTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class NumberResult(Result, NumberTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class AreaResult(Result, AreaTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PointResult(Result, PointTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class StringResult(Result, StringTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PathResult(Result, PathTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class TagResult(Result, TagTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class IdentifiablePointResult(Result, IdentifiablePointTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class AreaFeatureResult(Result, AreaFeatureTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class AnyResult(Result, AnyTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PointFeatureResult(Result, PointFeatureTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class RelationFeatureResult(Result, RelationFeatureTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class FloatResult(Result, FloatTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PointCollectionResult(Result, PointCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PointResult

class IntResult(Result, IntTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PathFeatureResult(Result, PathFeatureTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class FeatureIDResult(Result, FeatureIDTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class AreaCollectionResult(Result, AreaCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AreaResult

class PathCollectionResult(Result, PathCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PathResult

class AnyRenderableCollectionResult(Result, AnyRenderableCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return RenderableResult

class QueryProtoResult(Result, QueryProtoTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class StringPointCollectionResult(Result, StringPointCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PointResult

class IntStringCollectionResult(Result, IntStringCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return StringResult

class RelationFeatureCollectionResult(Result, RelationFeatureCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return RelationFeatureResult

class AnyFloatCollectionResult(Result, AnyFloatCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FloatResult

class PointFeatureCollectionResult(Result, PointFeatureCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PointFeatureResult

class StringStringCollectionResult(Result, StringStringCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return StringResult

class AreaFeatureCollectionResult(Result, AreaFeatureCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AreaFeatureResult

class StringAreaCollectionResult(Result, StringAreaCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return AreaResult

class FeatureCollectionResult(Result, FeatureCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FeatureResult

class IntTagCollectionResult(Result, IntTagCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return TagResult

class GeoJSONResult(Result, GeoJSONTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class FeatureIDIntCollectionResult(Result, FeatureIDIntCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return IntResult

class QueryResult(Result, QueryTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class BoolResult(Result, BoolTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PairResult(Result, PairTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class PathFeatureCollectionResult(Result, PathFeatureCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return PathFeatureResult

class FeatureIDTagCollectionResult(Result, FeatureIDTagCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return TagResult

class FeatureIDStringCollectionResult(Result, FeatureIDStringCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return StringResult

class FeatureIDFeatureIDCollectionResult(Result, FeatureIDFeatureIDCollectionTraits):
    def __init__(self, node):
        Result.__init__(self, node)

    @classmethod
    def _values(cls):
        return FeatureIDResult

class ChangeResult(Result, ChangeTraits):
    def __init__(self, node):
        Result.__init__(self, node)

class FunctionAreaGeometryResult(Result, Callable[[AreaTraits],GeometryTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : AreaTraits) -> GeometryTraits:
        raise NotImplementedError()

class FunctionAnyAnyResult(Result, Callable[[AnyTraits],AnyTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : AnyTraits) -> AnyTraits:
        raise NotImplementedError()

class FunctionPointGeometryResult(Result, Callable[[PointTraits],GeometryTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : PointTraits) -> GeometryTraits:
        raise NotImplementedError()

class FunctionPairAnyResult(Result, Callable[[PairTraits],AnyTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : PairTraits) -> AnyTraits:
        raise NotImplementedError()

class FunctionPathGeometryResult(Result, Callable[[PathTraits],GeometryTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : PathTraits) -> GeometryTraits:
        raise NotImplementedError()

class FunctionAnyBoolResult(Result, Callable[[AnyTraits],BoolTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : AnyTraits) -> BoolTraits:
        raise NotImplementedError()

class FunctionAnyResult(Result, Callable[[],AnyTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, ) -> AnyTraits:
        raise NotImplementedError()

class FunctionGeometryGeometryResult(Result, Callable[[GeometryTraits],GeometryTraits]):

    def __init__(self, node):
        Result.__init__(self, node)

    def __call__(self, a0 : GeometryTraits) -> GeometryTraits:
        raise NotImplementedError()

def closest_distance(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits, a3: QueryTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('closest-distance'), [a0, a1, a2, a3]))

def cap_polygon(a0: PointTraits, a1: FloatTraits) -> AreaTraits:
    return AreaResult(Call(Symbol('cap-polygon'), [a0, a1]))

def apply_to_area(a0: Callable[[AreaTraits],GeometryTraits]) -> Callable[[GeometryTraits],GeometryTraits]:
    return FunctionGeometryGeometryResult(Call(Symbol('apply-to-area'), [a0]))

def pair(a0: AnyTraits, a1: AnyTraits) -> PairTraits:
    return PairResult(Call(Symbol('pair'), [a0, a1]))

def and_(a0: QueryTraits, a1: QueryTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('and'), [a0, a1]))

def take(a0: CollectionResult, a1: IntTraits) -> CollectionResult:
    return CollectionResult(Call(Symbol('take'), [a0, a1]))

def find_feature(a0: FeatureIDTraits) -> FeatureTraits:
    return FeatureResult(Call(Symbol('find-feature'), [a0]))

def point_paths(a0: IdentifiablePointTraits) -> PathFeatureCollectionResult:
    return PathFeatureCollectionResult(Call(Symbol('point-paths'), [a0]))

def ordered_join(a0: PathTraits, a1: PathTraits) -> PathTraits:
    return PathResult(Call(Symbol('ordered-join'), [a0, a1]))

def area(a0: AreaTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('area'), [a0]))

def find_areas(a0: QueryTraits) -> AreaFeatureCollectionResult:
    return AreaFeatureCollectionResult(Call(Symbol('find-areas'), [a0]))

def degree(a0: PointFeatureTraits) -> IntTraits:
    return IntResult(Call(Symbol('degree'), [a0]))

def s2_polygon(a0: StringTraits) -> AreaTraits:
    return AreaResult(Call(Symbol('s2-polygon'), [a0]))

def has_key(a0: FeatureTraits, a1: StringTraits) -> BoolTraits:
    return BoolResult(Call(Symbol('has-key'), [a0, a1]))

def join(a0: PathTraits, a1: PathTraits) -> PathTraits:
    return PathResult(Call(Symbol('join'), [a0, a1]))

def s2_points(a0: AreaTraits, a1: IntTraits, a2: IntTraits) -> StringPointCollectionResult:
    return StringPointCollectionResult(Call(Symbol('s2-points'), [a0, a1, a2]))

def snap_area_edges(a0: AreaTraits, a1: QueryTraits, a2: FloatTraits) -> AreaTraits:
    return AreaResult(Call(Symbol('snap-area-edges'), [a0, a1, a2]))

def paths_to_reach(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits, a3: QueryTraits) -> FeatureIDIntCollectionResult:
    return FeatureIDIntCollectionResult(Call(Symbol('paths-to-reach'), [a0, a1, a2, a3]))

def to_geojson(a0: RenderableTraits) -> GeoJSONTraits:
    return GeoJSONResult(Call(Symbol('to-geojson'), [a0]))

def map_items(a0: CollectionResult, a1: Callable[[PairTraits],AnyTraits]) -> CollectionResult:
    return CollectionResult(Call(Symbol('map-items'), [a0, a1]))

def tagged(a0: StringTraits, a1: StringTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('tagged'), [a0, a1]))

def clamp(a0: IntTraits, a1: IntTraits, a2: IntTraits) -> IntTraits:
    return IntResult(Call(Symbol('clamp'), [a0, a1, a2]))

def connect(a0: PointFeatureTraits, a1: PointFeatureTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('connect'), [a0, a1]))

def to_geojson_collection(a0: AnyRenderableCollectionResult) -> GeoJSONTraits:
    return GeoJSONResult(Call(Symbol('to-geojson-collection'), [a0]))

def apply_to_path(a0: Callable[[PathTraits],GeometryTraits]) -> Callable[[GeometryTraits],GeometryTraits]:
    return FunctionGeometryGeometryResult(Call(Symbol('apply-to-path'), [a0]))

def type_point() -> QueryProtoTraits:
    return QueryProtoResult(Call(Symbol('type-point'), []))

def float_value(a0: TagTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('float-value'), [a0]))

def geojson_areas(a0: GeoJSONTraits) -> StringAreaCollectionResult:
    return StringAreaCollectionResult(Call(Symbol('geojson-areas'), [a0]))

def find_point(a0: FeatureIDTraits) -> PointFeatureTraits:
    return PointFeatureResult(Call(Symbol('find-point'), [a0]))

def find_points(a0: QueryTraits) -> PointFeatureCollectionResult:
    return PointFeatureCollectionResult(Call(Symbol('find-points'), [a0]))

def value(a0: TagTraits) -> StringTraits:
    return StringResult(Call(Symbol('value'), [a0]))

def reachable(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits, a3: QueryTraits) -> FeatureCollectionResult:
    return FeatureCollectionResult(Call(Symbol('reachable'), [a0, a1, a2, a3]))

def distance_meters(a0: PointTraits, a1: PointTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('distance-meters'), [a0, a1]))

def add_tags(a0: FeatureIDTagCollectionResult) -> ChangeTraits:
    return ChangeResult(Call(Symbol('add-tags'), [a0]))

def intersecting_cap(a0: PointTraits, a1: FloatTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('intersecting-cap'), [a0, a1]))

def add_point(a0: PointTraits, a1: StringPointCollectionResult) -> StringPointCollectionResult:
    return StringPointCollectionResult(Call(Symbol('add-point'), [a0, a1]))

def find_area(a0: FeatureIDTraits) -> AreaFeatureTraits:
    return AreaFeatureResult(Call(Symbol('find-area'), [a0]))

def gt(a0: AnyTraits, a1: AnyTraits) -> BoolTraits:
    return BoolResult(Call(Symbol('gt'), [a0, a1]))

def collection(a0: AnyTraits, a1: AnyTraits) -> CollectionResult:
    return CollectionResult(Call(Symbol('collection'), [a0, a1]))

def or_(a0: QueryTraits, a1: QueryTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('or'), [a0, a1]))

def int_value(a0: TagTraits) -> IntTraits:
    return IntResult(Call(Symbol('int-value'), [a0]))

def get_string(a0: IdentifiableTraits, a1: StringTraits) -> StringTraits:
    return StringResult(Call(Symbol('get-string'), [a0, a1]))

def empty_points() -> StringPointCollectionResult:
    return StringPointCollectionResult(Call(Symbol('empty-points'), []))

def second(a0: PairTraits) -> AnyTraits:
    return AnyResult(Call(Symbol('second'), [a0]))

def find_relations(a0: QueryTraits) -> RelationFeatureCollectionResult:
    return RelationFeatureCollectionResult(Call(Symbol('find-relations'), [a0]))

def map_geometries(a0: GeoJSONTraits, a1: Callable[[GeometryTraits],GeometryTraits]) -> GeoJSONTraits:
    return GeoJSONResult(Call(Symbol('map-geometries'), [a0, a1]))

def building_access(a0: FeatureCollectionResult, a1: FloatTraits, a2: StringTraits) -> FeatureIDFeatureIDCollectionResult:
    return FeatureIDFeatureIDCollectionResult(Call(Symbol('building-access'), [a0, a1, a2]))

def debug_all_query(a0: StringTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('debug-all-query'), [a0]))

def count_values(a0: CollectionResult) -> CollectionResult:
    return CollectionResult(Call(Symbol('count-values'), [a0]))

def within(a0: AreaTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('within'), [a0]))

def import_geojson(a0: GeoJSONTraits, a1: StringTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('import-geojson'), [a0, a1]))

def add_tag(a0: IdentifiableTraits, a1: TagTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('add-tag'), [a0, a1]))

def map_parallel(a0: CollectionResult, a1: Callable[[AnyTraits],AnyTraits]) -> CollectionResult:
    return CollectionResult(Call(Symbol('map-parallel'), [a0, a1]))

def sum_by_key(a0: CollectionResult) -> CollectionResult:
    return CollectionResult(Call(Symbol('sum-by-key'), [a0]))

def keyed(a0: StringTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('keyed'), [a0]))

def sample_points(a0: PathTraits, a1: FloatTraits) -> StringPointCollectionResult:
    return StringPointCollectionResult(Call(Symbol('sample-points'), [a0, a1]))

def find_paths(a0: QueryTraits) -> PathFeatureCollectionResult:
    return PathFeatureCollectionResult(Call(Symbol('find-paths'), [a0]))

def type_path() -> QueryProtoTraits:
    return QueryProtoResult(Call(Symbol('type-path'), []))

def type_area() -> QueryProtoTraits:
    return QueryProtoResult(Call(Symbol('type-area'), []))

def within_cap(a0: PointTraits, a1: FloatTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('within-cap'), [a0, a1]))

def s2_covering(a0: AreaTraits, a1: IntTraits, a2: IntTraits) -> StringStringCollectionResult:
    return StringStringCollectionResult(Call(Symbol('s2-covering'), [a0, a1, a2]))

def centroid(a0: GeometryTraits) -> PointTraits:
    return PointResult(Call(Symbol('centroid'), [a0]))

def find(a0: QueryTraits) -> FeatureCollectionResult:
    return FeatureCollectionResult(Call(Symbol('find'), [a0]))

def all() -> QueryTraits:
    return QueryResult(Call(Symbol('all'), []))

def distance_to_point_meters(a0: PathTraits, a1: PointTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('distance-to-point-meters'), [a0, a1]))

def point_features(a0: FeatureTraits) -> PointFeatureCollectionResult:
    return PointFeatureCollectionResult(Call(Symbol('point-features'), [a0]))

def count(a0: CollectionResult) -> IntTraits:
    return IntResult(Call(Symbol('count'), [a0]))

def tile_ids(a0: FeatureTraits) -> FeatureIDIntCollectionResult:
    return FeatureIDIntCollectionResult(Call(Symbol('tile-ids'), [a0]))

def find_path(a0: FeatureIDTraits) -> PathFeatureTraits:
    return PathFeatureResult(Call(Symbol('find-path'), [a0]))

def tag(a0: StringTraits, a1: StringTraits) -> TagTraits:
    return TagResult(Call(Symbol('tag'), [a0, a1]))

def points(a0: GeometryTraits) -> PointCollectionResult:
    return PointCollectionResult(Call(Symbol('points'), [a0]))

def apply_to_point(a0: Callable[[PointTraits],GeometryTraits]) -> Callable[[GeometryTraits],GeometryTraits]:
    return FunctionGeometryGeometryResult(Call(Symbol('apply-to-point'), [a0]))

def get(a0: IdentifiableTraits, a1: StringTraits) -> TagTraits:
    return TagResult(Call(Symbol('get'), [a0, a1]))

def rectangle_polygon(a0: PointTraits, a1: PointTraits) -> AreaTraits:
    return AreaResult(Call(Symbol('rectangle-polygon'), [a0, a1]))

def s2_grid(a0: AreaTraits, a1: IntTraits) -> StringStringCollectionResult:
    return StringStringCollectionResult(Call(Symbol('s2-grid'), [a0, a1]))

def sightline(a0: PointTraits, a1: FloatTraits) -> AreaTraits:
    return AreaResult(Call(Symbol('sightline'), [a0, a1]))

def parse_geojson(a0: StringTraits) -> GeoJSONTraits:
    return GeoJSONResult(Call(Symbol('parse-geojson'), [a0]))

def remove_tags(a0: FeatureIDStringCollectionResult) -> ChangeTraits:
    return ChangeResult(Call(Symbol('remove-tags'), [a0]))

filter = diagonal_b6.expression._filter

def intersecting(a0: GeometryTraits) -> QueryTraits:
    return QueryResult(Call(Symbol('intersecting'), [a0]))

def percentiles(a0: AnyFloatCollectionResult) -> AnyFloatCollectionResult:
    return AnyFloatCollectionResult(Call(Symbol('percentiles'), [a0]))

def tile_paths(a0: GeometryTraits, a1: IntTraits) -> IntStringCollectionResult:
    return IntStringCollectionResult(Call(Symbol('tile-paths'), [a0, a1]))

def all_tags(a0: IdentifiableTraits) -> IntTagCollectionResult:
    return IntTagCollectionResult(Call(Symbol('all-tags'), [a0]))

def reachable_points(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits, a3: QueryTraits) -> PointFeatureCollectionResult:
    return PointFeatureCollectionResult(Call(Symbol('reachable-points'), [a0, a1, a2, a3]))

def closest(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits, a3: QueryTraits) -> FeatureTraits:
    return FeatureResult(Call(Symbol('closest'), [a0, a1, a2, a3]))

def interpolate(a0: PathTraits, a1: FloatTraits) -> PointTraits:
    return PointResult(Call(Symbol('interpolate'), [a0, a1]))

def import_geojson_file(a0: StringTraits, a1: StringTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('import-geojson-file'), [a0, a1]))

def debug_tokens(a0: IdentifiableTraits) -> IntStringCollectionResult:
    return IntStringCollectionResult(Call(Symbol('debug-tokens'), [a0]))

def first(a0: PairTraits) -> AnyTraits:
    return AnyResult(Call(Symbol('first'), [a0]))

def sample_points_along_paths(a0: PathCollectionResult, a1: FloatTraits) -> PointCollectionResult:
    return PointCollectionResult(Call(Symbol('sample-points-along-paths'), [a0, a1]))

def divide(a0: NumberTraits, a1: NumberTraits) -> NumberTraits:
    return NumberResult(Call(Symbol('divide'), [a0, a1]))

def ll(a0: FloatTraits, a1: FloatTraits) -> PointTraits:
    return PointResult(Call(Symbol('ll'), [a0, a1]))

def tile_ids_hex(a0: FeatureTraits) -> FeatureIDStringCollectionResult:
    return FeatureIDStringCollectionResult(Call(Symbol('tile-ids-hex'), [a0]))

def find_relation(a0: FeatureIDTraits) -> RelationFeatureTraits:
    return RelationFeatureResult(Call(Symbol('find-relation'), [a0]))

def add_ints(a0: IntTraits, a1: IntTraits) -> IntTraits:
    return IntResult(Call(Symbol('add-ints'), [a0, a1]))

def flattern(a0: CollectionResult) -> CollectionResult:
    return CollectionResult(Call(Symbol('flattern'), [a0]))

def get_int(a0: IdentifiableTraits, a1: StringTraits) -> IntTraits:
    return IntResult(Call(Symbol('get-int'), [a0, a1]))

def s2_center(a0: StringTraits) -> PointTraits:
    return PointResult(Call(Symbol('s2-center'), [a0]))

def with_change(a0: ChangeTraits, a1: Callable[[],AnyTraits]) -> AnyTraits:
    return AnyResult(Call(Symbol('with-change'), [a0, a1]))

def export_world(a0: StringTraits) -> IntTraits:
    return IntResult(Call(Symbol('export-world'), [a0]))

def containing_areas(a0: PointFeatureCollectionResult, a1: QueryTraits) -> AreaFeatureCollectionResult:
    return AreaFeatureCollectionResult(Call(Symbol('containing-areas'), [a0, a1]))

def count_tag_value(a0: IdentifiableTraits, a1: StringTraits) -> CollectionResult:
    return CollectionResult(Call(Symbol('count-tag-value'), [a0, a1]))

def reachable_area(a0: FeatureTraits, a1: StringTraits, a2: FloatTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('reachable-area'), [a0, a1, a2]))

def get_float(a0: IdentifiableTraits, a1: StringTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('get-float'), [a0, a1]))

def length(a0: PathFeatureTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('length'), [a0]))

def remove_tag(a0: IdentifiableTraits, a1: StringTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('remove-tag'), [a0, a1]))

def divide_int(a0: IntTraits, a1: FloatTraits) -> FloatTraits:
    return FloatResult(Call(Symbol('divide-int'), [a0, a1]))

map = diagonal_b6.expression._map

def connect_to_network(a0: FeatureTraits) -> ChangeTraits:
    return ChangeResult(Call(Symbol('connect-to-network'), [a0]))

