# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-18 13:20
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import shop.models.fields
from shop.models.notification import Notify


def forwards(apps, schema_editor):
    if schema_editor.connection.alias != 'default':
        return
    Notification = apps.get_model('shop', 'Notification')
    for row in Notification.objects.all():
        if row.mail_to is None:
            row.notify = Notify.NOBODY
        if row.mail_to == 0:
            row.mail_to = None
            row.notify = Notify.CUSTOMER
        row.save(update_fields=['mail_to', 'notify'])


def backwards(apps, schema_editor):
    if schema_editor.connection.alias != 'default':
        return
    Notification = apps.get_model('shop', 'Notification')
    for row in Notification.objects.all():
        if row.notify is Notify.NOBODY:
            row.mail_to = None
        if row.notify is Notify.CUSTOMER:
            row.mail_to = 0
        row.save(update_fields=['mail_to'])


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('shop', '0006_rename_to_catalog'),
    ]

    operations = [
        migrations.AddField(
            model_name='notification',
            name='notify',
            field=shop.models.fields.ChoiceEnumField(verbose_name='Whom to notify', default=Notify.NOBODY),
        ),
        migrations.RunPython(forwards, reverse_code=backwards),
        migrations.RenameField(
            model_name='notification',
            old_name='mail_to',
            new_name='recipient',
        ),
        migrations.AlterField(
            model_name='notification',
            name='recipient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL, verbose_name='Recipient'),
        ),
        migrations.AlterModelOptions(
            name='notification',
            options={'ordering': ['transition_target', 'recipient_id'], 'verbose_name': 'Notification',
                     'verbose_name_plural': 'Notifications'},
        ),
    ]
