# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-10-10 20:52
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations

def forwards(apps, schema_editor):
    CascadeElement = apps.get_model('cmsplugin_cascade', 'CascadeElement')
    for element in CascadeElement.objects.all():
        if element.plugin_type == 'BillingAddressFormPlugin':
            element.plugin_type = 'CheckoutAddressPlugin'
            element.glossary['address_form'] = 'billing'
            element.glossary['allow_use_primary'] = element.glossary.get('allow_use_shipping', '')
            element.save()
        elif element.plugin_type == 'ShippingAddressFormPlugin':
            element.plugin_type = 'CheckoutAddressPlugin'
            element.glossary['address_form'] = 'shipping'
            element.save()


def backwards(apps, schema_editor):
    CascadeElement = apps.get_model('cmsplugin_cascade', 'CascadeElement')
    for element in CascadeElement.objects.all():
        if element.plugin_type == 'CheckoutAddressPlugin':
            if element.glossary['address_form'] == 'billing':
                element.plugin_type = 'BillingAddressFormPlugin'
                element.glossary['allow_use_shipping'] = element.glossary.get('allow_use_primary', '')
            elif element.glossary['address_form'] == 'shipping':
                element.plugin_type = 'ShippingAddressFormPlugin'
            element.save()



class Migration(migrations.Migration):

    dependencies = [
        ('shop', '0004_ckeditor31'),
    ]
    operations = []

    if 'cmsplugin_cascade' in settings.INSTALLED_APPS:
        dependencies.append(('cmsplugin_cascade', '0017_fake_proxy_models'))
        operations.append(migrations.RunPython(forwards, reverse_code=backwards))
