/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Construct } from "constructs";
export interface SonarCodeScannerConfig {
    /**
     * path to a file containing the cfn nag suppression rules.
     */
    readonly cfnNagIgnorePath?: string;
    /**
     * directory containing the synthesized cdk resources.
     */
    readonly cdkOutDir?: string;
    /**
     * glob patterns to exclude from sonar scan.
     */
    readonly excludeGlobsForScan?: string[];
    /**
     * glob patterns to include from sonar scan.
     */
    readonly includeGlobsForScan?: string[];
    /**
     * endpoint of the sonarqube instance i.e: https://<your-sonarqube-endpoint>.
     *
     * Note: Ensure a trailing '/' is not included.
     */
    readonly sonarqubeEndpoint: string;
    /**
     * Default profile/gate name i.e: your org profile.
     *
     * Note: These need to be set up in Sonarqube manually.
     */
    readonly sonarqubeDefaultProfileOrGateName: string;
    /**
     * Specific profile/gate name i.e: language specific.
     *
     * Note: These need to be set up in Sonarqube manually.
     */
    readonly sonarqubeSpecificProfileOrGateName?: string;
    /**
     * Group name in Sonarqube with access to administer this project.
     */
    readonly sonarqubeAuthorizedGroup: string;
    /**
     * Name of the project to create in Sonarqube.
     */
    readonly sonarqubeProjectName: string;
    /**
     * Tags to associate with this project.
     */
    readonly sonarqubeTags?: string[];
    /**
     * Hook which allows custom commands to be executed before the process commences the archival process.
     */
    readonly preArchiveCommands?: string[];
}
/**
 * SonarCodeScanners properties.
 */
export interface SonarCodeScannerProps extends SonarCodeScannerConfig {
    /**
     * ARN for the CodeBuild task responsible for executing the synth command.
     */
    readonly synthBuildArn: string;
    /**
     * S3 bucket ARN containing the built artifacts from the synth build.
     */
    readonly artifactBucketArn: string;
    /**
     * Artifact bucket key ARN used to encrypt the artifacts.
     */
    readonly artifactBucketKeyArn?: string;
}
export declare class SonarCodeScanner extends Construct {
    constructor(scope: Construct, id: string, props: SonarCodeScannerProps);
}
